/*
 * Decompiled with CFR 0.152.
 */
package choco.kernel.common.util;

import choco.kernel.common.util.IPrioritizable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PriorityQueue {
    private static Logger logger = Logger.getLogger("choco");
    private final int levelNb;
    private Entry[] levelLast;
    private Entry header;
    private HashMap map;
    private int size;

    public PriorityQueue(int levelNb) {
        this.levelNb = levelNb;
        this.size = 0;
        this.map = new HashMap();
        this.header.next = this.header.previous = (this.header = new Entry(null, null, null, -1));
        this.levelLast = new Entry[levelNb];
        for (int i = 0; i < levelNb; ++i) {
            this.levelLast[i] = this.header;
        }
    }

    public PriorityQueue() {
        this(5);
    }

    public boolean add(Object o) {
        try {
            IPrioritizable p = (IPrioritizable)o;
            return this.add(o, p.getPriority());
        }
        catch (ClassCastException e) {
            throw new UnsupportedOperationException();
        }
    }

    public boolean add(Object o, int priority) {
        if (!this.map.containsKey(o)) {
            Entry newEntry = new Entry(o, null, null, priority);
            newEntry.previous = this.levelLast[priority];
            newEntry.next = this.levelLast[priority].next;
            newEntry.next.previous = newEntry;
            newEntry.previous.next = newEntry;
            for (int prior = priority; prior < this.levelNb && this.levelLast[prior].priority <= priority; ++prior) {
                this.levelLast[prior] = newEntry;
            }
            this.map.put(o, newEntry);
            ++this.size;
            return true;
        }
        if (logger.isLoggable(Level.SEVERE)) {
            logger.severe("PriorityQueue: Element added already in the queue !");
        }
        return false;
    }

    public boolean addAll(Collection c) {
        boolean anyAddition = false;
        for (Object o : c) {
            anyAddition = anyAddition || this.add(o);
        }
        return anyAddition;
    }

    public void clear() {
        this.header.next = this.header.previous = this.header;
        this.size = 0;
        this.map.clear();
        for (int i = 0; i < this.levelNb; ++i) {
            this.levelLast[i] = this.header;
        }
    }

    public boolean contains(Object o) {
        return this.map.containsKey(o);
    }

    public boolean containsAll(Collection c) {
        boolean oneOut = false;
        Iterator it = c.iterator();
        while (it.hasNext() && !oneOut) {
            Object o = it.next();
            if (this.contains(o)) continue;
            oneOut = true;
        }
        return !oneOut;
    }

    public boolean equals(Object o) {
        return o == this;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public Iterator iterator() {
        return new PQIterator();
    }

    public Object popFirst() {
        if (this.size == 0) {
            throw new NoSuchElementException();
        }
        Object ret = this.header.next.element;
        this.remove(ret);
        return ret;
    }

    public boolean remove(Object o) {
        Entry entry = (Entry)this.map.get(o);
        if (entry != null) {
            this.map.remove(o);
            entry.previous.next = entry.next;
            entry.next.previous = entry.previous;
            for (int prio = entry.priority; prio < this.levelNb && this.levelLast[prio] == entry; ++prio) {
                this.levelLast[prio] = entry.previous;
            }
            entry = null;
            --this.size;
            return true;
        }
        return false;
    }

    public boolean removeAll(Collection c) {
        boolean oneWasIn = false;
        for (Object o : c) {
            if (!this.remove(o)) continue;
            oneWasIn = true;
        }
        return oneWasIn;
    }

    public boolean retainAll(Collection c) {
        throw new UnsupportedOperationException();
    }

    public int size() {
        return this.size;
    }

    public Object[] toArray() {
        Object[] ret = new Object[this.size];
        Entry current = this.header.next;
        for (int i = 0; i < this.size; ++i) {
            ret[i] = current.element;
            current = current.next;
        }
        if (current != this.header && logger.isLoggable(Level.SEVERE)) {
            logger.log(Level.SEVERE, "Model in PriorityQueue implementation !");
        }
        return ret;
    }

    public Object[] toArray(Object[] a) {
        throw new UnsupportedOperationException();
    }

    public void updatePriority(Object o) {
        try {
            IPrioritizable p = (IPrioritizable)o;
            this.updatePriority(o, p.getPriority());
        }
        catch (ClassCastException e) {
            throw new UnsupportedOperationException();
        }
    }

    public void updatePriority(Object o, int priority) {
        Entry entry = (Entry)this.map.get(o);
        if (entry != null) {
            if (priority != entry.priority) {
                for (int prio = entry.priority; prio < this.levelNb && this.levelLast[prio] == entry; ++prio) {
                    this.levelLast[prio] = entry.previous;
                }
                entry.previous.next = entry.next;
                entry.next.previous = entry.previous;
                entry.priority = priority;
                entry.previous = this.levelLast[priority];
                entry.next = this.levelLast[priority].next;
                entry.next.previous = entry;
                entry.previous.next = entry;
                for (int prior = priority; prior < this.levelNb && this.levelLast[prior].priority <= priority; ++prior) {
                    this.levelLast[prior] = entry;
                }
            }
        } else if (logger.isLoggable(Level.SEVERE)) {
            logger.log(Level.SEVERE, "Model in the PriorityQueue update.");
        }
    }

    private class PQIterator
    implements Iterator {
        Entry cursor;

        private PQIterator() {
            this.cursor = PriorityQueue.this.header;
        }

        @Override
        public boolean hasNext() {
            return this.cursor.next != PriorityQueue.this.header;
        }

        public Object next() {
            this.cursor = this.cursor.next;
            return this.cursor.element;
        }

        @Override
        public void remove() {
        }
    }

    private static class Entry {
        int priority;
        Object element;
        Entry next;
        Entry previous;

        Entry(Object element, Entry next, Entry previous, int priority) {
            this.element = element;
            this.next = next;
            this.previous = previous;
            this.priority = priority;
        }
    }
}

