/*
 * Decompiled with CFR 0.152.
 */
package choco.kernel.common.util;

import java.util.logging.Formatter;
import java.util.logging.LogRecord;

public class LightFormatter
extends Formatter {
    private static final String lineSeparator = System.getProperty("line.separator");
    private static final String[] logPrefix = new String[]{"", ".", "..", "...", "....", ".....", "......", ".......", "........", ".........", ".........."};

    private static final String getLogPrefix(int n) {
        return logPrefix[n % logPrefix.length];
    }

    @Override
    public synchronized String format(LogRecord record) {
        StringBuilder sb = new StringBuilder();
        if ("choco".equals(record.getLoggerName())) {
            sb.append("===").append(record.getMessage());
        } else if (record.getLoggerName().startsWith("choco.kernel.solver.search.branching")) {
            Object[] parameters = record.getParameters();
            int depth = (Integer)parameters[0];
            sb.append(LightFormatter.getLogPrefix(depth)).append('[').append(depth).append("] ").append(record.getMessage()).append(parameters[1]).append(parameters[2]).append(parameters[3]);
        } else {
            sb.append(record.getMessage());
        }
        sb.append(lineSeparator);
        return sb.toString();
    }
}

