/*
 * Decompiled with CFR 0.152.
 */
package choco.kernel.common.util;

import choco.kernel.common.util.IntIterator;

public class IntList {
    protected int[] content;
    protected int size;
    protected int currentIdx = 0;

    public IntList(int size) {
        this.size = size;
        this.content = new int[size];
    }

    public IntList(int[] content, int size) {
        this.content = content;
        this.size = size;
    }

    public IntList copy() {
        int[] copContent = new int[this.content.length];
        System.arraycopy(this.content, 0, copContent, 0, copContent.length);
        return new IntList(copContent, this.size);
    }

    public int getFirst() {
        if (this.size > 0) {
            return this.content[0];
        }
        throw new IllegalArgumentException("List is empty");
    }

    public int getSize() {
        return this.size;
    }

    public void reInit() {
        this.size = 0;
    }

    public void add(int v) {
        if (this.size == this.content.length) {
            throw new IllegalArgumentException("" + this.size);
        }
        this.content[this.size++] = v;
    }

    public IntIterator iterator() {
        return new IntListIterator();
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append('{');
        IntIterator iter = this.iterator();
        if (iter.hasNext()) {
            b.append(iter.next());
            while (iter.hasNext()) {
                b.append(',').append(iter.next());
            }
        }
        b.append('}');
        return new String(b);
    }

    private class IntListIterator
    implements IntIterator {
        int currentIdx = 0;
        int maxSize;

        @Override
        public boolean hasNext() {
            return this.currentIdx < IntList.this.size;
        }

        @Override
        public int next() {
            return IntList.this.content[this.currentIdx++];
        }

        @Override
        public void remove() {
            if (this.currentIdx != IntList.this.size) {
                --this.currentIdx;
                IntList.this.content[this.currentIdx] = IntList.this.content[IntList.this.size - 1];
            }
            --IntList.this.size;
        }

        public int read() {
            return IntList.this.content[this.currentIdx];
        }
    }
}

