/*
 * Decompiled with CFR 0.152.
 */
package choco.kernel.common.util;

import choco.kernel.common.util.IntIterator;

public abstract class DisposableIntIterator
implements IntIterator {
    public boolean reusable;
    static OneValueIterator onevalueiterator;

    public void init() {
        this.reusable = false;
    }

    public void dispose() {
        this.reusable = true;
    }

    public static OneValueIterator getOneValueIterator(int value) {
        if (onevalueiterator != null && DisposableIntIterator.onevalueiterator.reusable) {
            onevalueiterator.init(value);
            return onevalueiterator;
        }
        OneValueIterator iter = new OneValueIterator(value);
        return iter;
    }

    private static class OneValueIterator
    extends DisposableIntIterator {
        int value;
        boolean next;

        public OneValueIterator(int value) {
            this.init(value);
        }

        public void init(int value) {
            super.init();
            this.value = value;
            this.next = true;
        }

        @Override
        public boolean hasNext() {
            return this.next;
        }

        @Override
        public int next() {
            this.next = false;
            return this.value;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

