/*
 * Decompiled with CFR 0.152.
 */
package choco.kernel.common.util;

import choco.IPretty;
import choco.kernel.common.util.AppendIterator;
import choco.kernel.common.util.ArrayIterator;
import choco.kernel.common.util.ConstantPermutation;
import choco.kernel.common.util.IPermutation;
import choco.kernel.common.util.Identity;
import choco.kernel.common.util.ImmutableListIterator;
import choco.kernel.common.util.IntPermutation;
import choco.kernel.common.util.SingleElementIterator;
import choco.kernel.model.variables.Variable;
import choco.kernel.model.variables.VariableType;
import choco.kernel.model.variables.integer.IntegerConstantVariable;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;

public final class ChocoUtil {
    private ChocoUtil() {
    }

    public static String pad(String str, int padlen, String pad) {
        String padding = new String();
        int len = Math.abs(padlen) - str.length();
        if (len < 1) {
            return str;
        }
        for (int i = 0; i < len; ++i) {
            padding = padding + pad;
        }
        return padlen < 0 ? padding + str : str + padding;
    }

    public static String pretty(IPretty[] elems, int begin, int end) {
        StringBuilder buffer = new StringBuilder();
        buffer.append("{ ");
        for (int i = begin; i < end; ++i) {
            buffer.append(elems[i].pretty()).append(", ");
        }
        buffer.deleteCharAt(buffer.length() - 2);
        buffer.append("}");
        return new String(buffer);
    }

    public static String pretty(IPretty ... elems) {
        return ChocoUtil.pretty(elems, 0, elems.length);
    }

    public static String prettyOnePerLine(Collection<? extends IPretty> elems) {
        return ChocoUtil.prettyOnePerLine(elems.iterator());
    }

    public static String prettyOnePerLine(Iterator<? extends IPretty> iter) {
        StringBuilder buffer = new StringBuilder();
        while (iter.hasNext()) {
            buffer.append(iter.next().pretty()).append('\n');
        }
        return new String(buffer);
    }

    public static String pretty(Collection<? extends IPretty> elems) {
        return ChocoUtil.pretty(elems.iterator());
    }

    public static String pretty(Iterator<? extends IPretty> iter) {
        StringBuilder buffer = new StringBuilder();
        buffer.append("{ ");
        if (iter.hasNext()) {
            while (iter.hasNext()) {
                buffer.append(iter.next().pretty()).append(", ");
            }
            buffer.deleteCharAt(buffer.length() - 2);
        }
        buffer.append("}");
        return new String(buffer);
    }

    public static <E> ListIterator<E> setImmutableIterator(ListIterator<E> iter) {
        return new ImmutableListIterator<E>(iter);
    }

    public static <E> ListIterator<E> getImmutableIterator(List<E> list) {
        return ChocoUtil.setImmutableIterator(list.listIterator());
    }

    public static <E> Iterator<E> iterator(E elem) {
        return new SingleElementIterator<E>(elem);
    }

    public static <E> Iterator<E> iterator(E[] array) {
        return new ArrayIterator<E>(array);
    }

    public static <E> Iterator<E> append(Iterator<E> ... iters) {
        return new AppendIterator<E>(iters);
    }

    public static <E> Iterator<E> iterator(List<E> ... lists) {
        Iterator[] iters = (Iterator[])Array.newInstance(Iterator.class, lists.length);
        for (int i = 0; i < lists.length; ++i) {
            iters[i] = ChocoUtil.getImmutableIterator(lists[i]);
        }
        return ChocoUtil.append(iters);
    }

    public static Iterator<Variable> variableIterator(Iterator<? extends Variable> ... iters) {
        return new AppendIterator<Variable>(iters);
    }

    public static <E> Iterator<E> appendAndCast(Iterator<? extends E> ... iters) {
        return new AppendIterator<E>(iters);
    }

    public static <E> Iterator<E> append(E[] ... arrays) {
        Iterator[] iters = (Iterator[])Array.newInstance(Iterator.class, arrays.length);
        for (int i = 0; i < arrays.length; ++i) {
            iters[i] = ChocoUtil.iterator(arrays[i]);
        }
        return ChocoUtil.append(iters);
    }

    public static int[] zeroToN(int n) {
        int[] r = new int[n];
        for (int i = 0; i < n; ++i) {
            r[i] = i;
        }
        return r;
    }

    public static int[] oneToN(int n) {
        int[] r = new int[n];
        for (int i = 1; i <= n; ++i) {
            r[i - 1] = i;
        }
        return r;
    }

    public static <T> T[] getColumn(T[][] array, int column) {
        if (array != null && array.length > 0 && column >= 0 && array[0].length > column) {
            Object[] res = (Object[])Array.newInstance(array[0][column].getClass(), array.length);
            for (int i = 0; i < array.length; ++i) {
                res[i] = array[i][column];
            }
            return res;
        }
        return null;
    }

    public static <T> int length(T[] ... arrays) {
        int length = 0;
        for (T[] array : arrays) {
            length += array.length;
        }
        return length;
    }

    public static <T> T get(int index, T[] ... arrays) {
        int shift = index;
        for (T[] tab : arrays) {
            if (shift < tab.length) {
                return tab[shift];
            }
            shift -= tab.length;
        }
        return null;
    }

    public static <T> T get(int index, List<T> ... arrays) {
        int shift = index;
        for (List<T> tab : arrays) {
            if (shift < tab.size()) {
                return tab.get(shift);
            }
            shift -= tab.size();
        }
        return null;
    }

    public static int checkType(VariableType v1, VariableType v2) {
        int t1 = 0;
        int t2 = 0;
        if (ChocoUtil.checkInteger(v1)) {
            t1 = 1;
        } else if (ChocoUtil.checkSet(v1)) {
            t1 = 2;
        } else if (ChocoUtil.checkReal(v1)) {
            t1 = 3;
        }
        if (ChocoUtil.checkInteger(v2)) {
            t2 = 1;
        } else if (ChocoUtil.checkSet(v2)) {
            t2 = 2;
        } else if (ChocoUtil.checkReal(v2)) {
            t2 = 3;
        }
        return 10 * t1 + t2;
    }

    public static <V> V[] getNonRedundantObjects(Class classe, V[] all) {
        Object[] a = (Object[])all.clone();
        Arrays.sort(a);
        Object[] c = (Object[])Array.newInstance(classe, a.length);
        int ind = 0;
        Object previous = null;
        for (int i = 0; i < a.length; ++i) {
            if (a[i].equals(previous)) continue;
            previous = a[i];
            c[ind++] = previous;
        }
        if (ind != a.length) {
            a = (Object[])Array.newInstance(classe, ind);
            System.arraycopy(c, 0, a, 0, ind);
        }
        c = null;
        return a;
    }

    public static boolean checkInteger(VariableType v) {
        return v == VariableType.INTEGER || v == VariableType.CONSTANT_INTEGER;
    }

    public static boolean checkSet(VariableType v) {
        return v == VariableType.SET || v == VariableType.CONSTANT_SET;
    }

    public static boolean checkReal(VariableType v) {
        return v == VariableType.REAL || v == VariableType.CONSTANT_DOUBLE || v == VariableType.REAL_EXPRESSION;
    }

    public static IPermutation getIdentity() {
        return Identity.SINGLETON;
    }

    public static IPermutation getSortingPermuation(int[] criteria) {
        return ChocoUtil.getSortingPermuation(criteria, false);
    }

    public static IPermutation getSortingPermuation(int[] criteria, boolean reverse) {
        return new IntPermutation(criteria, reverse);
    }

    public static IPermutation getSortingPermuation(IntegerConstantVariable[] criteria, boolean reverse) {
        return new ConstantPermutation(criteria, reverse);
    }

    public static IntegerConstantVariable[] applyPermutation(IPermutation permutation, IntegerConstantVariable[] source) {
        if (permutation.isIdentity()) {
            return source;
        }
        IntegerConstantVariable[] dest = new IntegerConstantVariable[source.length];
        permutation.applyPermutation(source, dest);
        return dest;
    }

    public static <T extends Comparable<T>> T[] sort(Set<T> set) {
        LinkedList<Object> tmpl = new LinkedList<Object>(set);
        if (tmpl.isEmpty()) {
            return null;
        }
        Object[] tmpa = (Comparable[])Array.newInstance(((Comparable)tmpl.getFirst()).getClass(), tmpl.size());
        tmpl.toArray(tmpa);
        Arrays.sort(tmpa);
        return tmpa;
    }
}

