/*
 * Decompiled with CFR 0.152.
 */
package choco.kernel.common.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;

public class BipartiteSet<E> {
    private static Logger logger = Logger.getLogger("choco");
    ArrayList<E> objects;
    int nbLeft = 0;
    HashMap<E, Integer> indices = new HashMap();

    public BipartiteSet() {
        this.objects = new ArrayList();
        this.indices = new HashMap();
    }

    private void swap(int idx1, int idx2) {
        if (idx1 != idx2) {
            E obj1 = this.objects.get(idx1);
            E obj2 = this.objects.get(idx2);
            this.objects.set(idx1, obj2);
            this.objects.set(idx2, obj1);
            this.indices.put(obj1, idx2);
            this.indices.put(obj2, idx1);
        }
    }

    public void moveLeft(E object) {
        Integer idx = this.indices.get(object);
        if (idx == null) {
            if (logger.isLoggable(Level.SEVERE)) {
                logger.logp(Level.SEVERE, "BipartiteSet", "moveLeft", "bipartite set does not contain " + object);
            }
        } else {
            int index = idx;
            if (index >= this.nbLeft) {
                this.swap(index, this.nbLeft++);
            }
        }
    }

    public void moveRight(E object) {
        Integer idx = this.indices.get(object);
        if (idx == null) {
            if (logger.isLoggable(Level.SEVERE)) {
                logger.logp(Level.SEVERE, "BipartiteSet", "moveRight", "bipartite set does not contain " + object);
            }
        } else {
            int index = idx;
            if (index < this.nbLeft) {
                this.swap(index, --this.nbLeft);
            }
        }
    }

    public void moveAllLeft() {
        this.nbLeft = this.objects.size();
    }

    public void moveAllRight() {
        this.nbLeft = 0;
    }

    public void addRight(E object) {
        if (this.indices.get(object) != null) {
            if (logger.isLoggable(Level.SEVERE)) {
                logger.logp(Level.SEVERE, "BipartiteSet", "addRight", object + "already in the set bipartite set ");
            }
        } else {
            this.objects.add(object);
            this.indices.put(object, this.objects.size() - 1);
        }
    }

    public void addLeft(E object) {
        this.addRight(object);
        this.moveLeft(object);
    }

    public boolean isLeft(E object) {
        Integer idx = this.indices.get(object);
        if (idx == null) {
            if (logger.isLoggable(Level.SEVERE)) {
                logger.logp(Level.SEVERE, "BipartiteSet", "isLeft", "bipartite set does not contain " + object);
            }
            return false;
        }
        int index = idx;
        return index < this.nbLeft;
    }

    public boolean isIn(E object) {
        return this.indices.get(object) != null;
    }

    public int getNbLeft() {
        return this.nbLeft;
    }

    public int getNbRight() {
        return this.objects.size() - this.nbLeft;
    }

    public int getNbObjects() {
        return this.objects.size();
    }

    public E moveLastLeft() {
        if (this.nbLeft > 0) {
            E ret = this.objects.get(--this.nbLeft);
            return ret;
        }
        return null;
    }

    public Iterator<E> leftIterator() {
        return new LeftItr();
    }

    public Iterator<E> rightIterator() {
        return new RightItr();
    }

    private class RightItr
    implements Iterator<E> {
        int cursor;

        private RightItr() {
            this.cursor = BipartiteSet.this.nbLeft;
        }

        @Override
        public boolean hasNext() {
            return this.cursor != BipartiteSet.this.objects.size();
        }

        @Override
        public E next() {
            return BipartiteSet.this.objects.get(this.cursor++);
        }

        @Override
        public void remove() {
        }
    }

    private class LeftItr
    implements Iterator<E> {
        int cursor = 0;

        private LeftItr() {
        }

        @Override
        public boolean hasNext() {
            return this.cursor != BipartiteSet.this.nbLeft;
        }

        @Override
        public E next() {
            return BipartiteSet.this.objects.get(this.cursor++);
        }

        @Override
        public void remove() {
        }
    }
}

