/*
 * Decompiled with CFR 0.152.
 */
package choco.kernel.common.opres.pack;

import choco.kernel.common.opres.pack.AbstractDDFF;
import choco.kernel.common.opres.pack.FunctionDDFF_f1;
import choco.kernel.common.opres.pack.FunctionDFF_f0;
import choco.kernel.common.opres.pack.FunctionDFF_f2;
import choco.kernel.common.opres.pack.LowerBound2BP;
import java.util.BitSet;

public final class LowerBoundFactory {
    private LowerBoundFactory() {
    }

    protected static AbstractDDFF[] createDDFF(int[] sizes, int capacity, BitSet selected) {
        return new AbstractDDFF[]{new FunctionDFF_f0(sizes, capacity, selected), new FunctionDDFF_f1(sizes, capacity, selected), new FunctionDFF_f2(sizes, capacity, selected)};
    }

    public static int computeL_DFF_1BP(int[] sizes, int capacity) {
        AbstractDDFF[] ddff = LowerBoundFactory.createDDFF(sizes, capacity, null);
        return LowerBoundFactory.computeL_DFF_1BP(ddff);
    }

    public static int computeL_DFF_1BP(int[] sizes, int capacity, int ub) {
        AbstractDDFF[] ddff = LowerBoundFactory.createDDFF(sizes, capacity, null);
        return LowerBoundFactory.computeL_DFF_1BP(ddff, ub);
    }

    public static int computeL_DFF_1BP(int[] sizes, int capacity, BitSet selected) {
        if (sizes.length > 0 && (selected == null || selected.cardinality() > 0)) {
            AbstractDDFF[] ddff = LowerBoundFactory.createDDFF(sizes, capacity, selected);
            return LowerBoundFactory.computeL_DFF_1BP(ddff);
        }
        return 0;
    }

    protected static int computeL_DFF_1BP(AbstractDDFF[] ddff, int ub) {
        int lbv = 0;
        for (int u = 0; u < ddff.length; ++u) {
            BitSet params = ddff[u].selectParameters();
            int k = params.nextSetBit(0);
            while (k >= 0) {
                int lb = ddff[u].applyFunction(k);
                if (lb > lbv && (lbv = lb) == ub) {
                    return lbv;
                }
                ddff[u].reset();
                k = params.nextSetBit(k + 1);
            }
        }
        return lbv;
    }

    protected static int computeL_DFF_1BP(AbstractDDFF[] ddff) {
        return LowerBoundFactory.computeL_DFF_1BP(ddff, ddff[0].computeUB());
    }

    protected static BitSet intersection(AbstractDDFF ddff1, AbstractDDFF ddff2) {
        BitSet r = (BitSet)ddff1.selected.clone();
        r.and(ddff2.selected);
        return r;
    }

    public static int computeL0(AbstractDDFF ddff1, AbstractDDFF ddff2) {
        double lb = 0.0;
        BitSet inter = LowerBoundFactory.intersection(ddff1, ddff2);
        int i = inter.nextSetBit(0);
        while (i >= 0) {
            lb += (double)(ddff1.sizes[i] * ddff2.sizes[i]);
            i = inter.nextSetBit(i + 1);
        }
        return AbstractDDFF.round(lb, ddff1.getCapacity() * ddff2.getCapacity());
    }

    public static int computeL_2CM(int[] widths, int cwidth, int[] heights, int cheight) {
        return new LowerBound2BP(widths, cwidth, heights, cheight).computeL_2CM();
    }
}

