/*
 * Decompiled with CFR 0.152.
 */
package choco.kernel.common.opres.pack;

import choco.kernel.common.opres.pack.AbstractDDFF;
import choco.kernel.common.opres.pack.LowerBoundFactory;
import java.util.BitSet;

public class LowerBound2BP {
    private static final int A_GR = 0;
    private static final int A_HT = 1;
    private static final int A_LG = 2;
    private static final int A_PT = 3;
    private final int n;
    private final int[] widths;
    private final int cwidth;
    private final int[] heights;
    private final int cheight;
    private boolean xAxisFirst = true;

    public LowerBound2BP(int[] widths, int cwidth, int[] heights, int cheight) {
        this(widths, cwidth, heights, cheight, false);
    }

    public LowerBound2BP(int[] widths, int cwidth, int[] heights, int cheight, boolean multiplyBy2) {
        this.widths = widths;
        this.heights = heights;
        this.n = this.widths.length;
        if (multiplyBy2) {
            this.cwidth = 2 * cwidth;
            this.cheight = 2 * cheight;
            int i = 0;
            while (i < widths.length) {
                int n = i;
                this.widths[n] = this.widths[n] * 2;
                int n2 = i++;
                this.heights[n2] = this.heights[n2] * 2;
            }
        } else {
            this.cwidth = cwidth;
            this.cheight = cheight;
        }
    }

    public final boolean isXAxisFirst() {
        return this.xAxisFirst;
    }

    public final void setXAxisFirst(boolean axisFirst) {
        this.xAxisFirst = axisFirst;
    }

    public long getArea() {
        return this.cwidth * this.cheight;
    }

    public long getEnergy() {
        long s = 0L;
        for (int i = 0; i < this.n; ++i) {
            s += (long)(this.widths[i] * this.heights[i]);
        }
        return s;
    }

    public int computeL0() {
        long s = this.getEnergy();
        return AbstractDDFF.round(s, this.getEnergy());
    }

    private static final int estimate(AbstractDDFF ddff1, AbstractDDFF ddff2) {
        double r = 0.0;
        int i = ddff1.selected.nextSetBit(0);
        while (i >= 0) {
            int nb = ddff2.storedCapacity / ddff2.storedSizes[i];
            double tmp = (double)ddff1.sizes[i] / (double)ddff1.capacity;
            r += tmp / (double)nb;
            i = ddff1.selected.nextSetBit(i + 1);
        }
        return (int)Math.ceil(r);
    }

    private int internalLoopDFF(AbstractDDFF ddff1, AbstractDDFF ddff2) {
        int lb = 0;
        ddff2.setStoredSelected(ddff1.getSelected());
        BitSet params = ddff2.selectParameters();
        int k = params.nextSetBit(0);
        while (k >= 0) {
            ddff2.applyFunction(k);
            int v = LowerBoundFactory.computeL0(ddff1, ddff2);
            if (v > lb) {
                lb = v;
            }
            ddff2.reset();
            k = params.nextSetBit(k + 1);
        }
        return lb;
    }

    public int computeL_DFF() {
        return this.computeL_DFF(this.xAxisFirst);
    }

    public int computeL_DFF(boolean xAxisFirst) {
        AbstractDDFF[] ddff1 = LowerBoundFactory.createDDFF(this.widths, this.cwidth, null);
        AbstractDDFF[] ddff2 = LowerBoundFactory.createDDFF(this.heights, this.cheight, null);
        if (!xAxisFirst) {
            AbstractDDFF[] temp = ddff1;
            ddff1 = ddff2;
            ddff2 = temp;
        }
        int lb = 0;
        for (int u = 0; u < ddff1.length; ++u) {
            BitSet params1 = ddff1[u].selectParameters();
            int k1 = params1.nextSetBit(0);
            while (k1 >= 0) {
                if (ddff1[u].applyFunction(k1) >= lb) {
                    int v = this.internalLoopDFF(ddff1[u], ddff2[1]);
                    if (v > lb) {
                        lb = v;
                    }
                    if (LowerBound2BP.estimate(ddff1[u], ddff2[1]) >= lb && (v = Math.max(this.internalLoopDFF(ddff1[u], ddff2[0]), this.internalLoopDFF(ddff1[u], ddff2[2]))) > lb) {
                        lb = v;
                    }
                }
                ddff1[u].reset();
                k1 = params1.nextSetBit(k1 + 1);
            }
        }
        return lb;
    }

    private BitSet[] extractSubsets(int k, int l) {
        int i;
        BitSet[] subsets = new BitSet[4];
        for (i = 0; i < subsets.length; ++i) {
            subsets[i] = new BitSet(this.n);
        }
        for (i = 0; i < this.n; ++i) {
            if (this.heights[i] <= this.cheight - l || this.widths[i] <= this.cwidth - k) continue;
            subsets[0].set(i);
        }
        int cpt = -1;
        while ((cpt = subsets[0].nextClearBit(cpt + 1)) < this.n) {
            if (this.heights[cpt] > this.cheight - l && this.widths[cpt] >= k) {
                subsets[1].set(cpt);
                continue;
            }
            if (this.heights[cpt] < l || this.widths[cpt] <= this.cwidth - k) continue;
            subsets[2].set(cpt);
        }
        subsets[3].set(0, this.n);
        for (int i2 = 0; i2 < subsets.length - 1; ++i2) {
            subsets[3].andNot(subsets[i2]);
        }
        cpt = -1;
        while ((cpt = subsets[3].nextSetBit(cpt + 1)) != -1) {
            if (this.heights[cpt] >= l && this.widths[cpt] >= k) continue;
            subsets[3].clear(cpt);
        }
        return subsets;
    }

    @Deprecated
    private int computeBM_1BP_1(BitSet[] subsets) {
        int s = 0;
        for (int i = 1; i < subsets.length; ++i) {
            s += subsets[i].cardinality();
        }
        int[] sizes = new int[s];
        int i = 0;
        int cpt = -1;
        while ((cpt = subsets[1].nextSetBit(cpt + 1)) != -1) {
            sizes[i] = this.widths[cpt] * this.cheight;
            ++i;
        }
        while ((cpt = subsets[2].nextSetBit(cpt + 1)) != -1) {
            sizes[i] = this.cwidth * this.heights[cpt];
            ++i;
        }
        while ((cpt = subsets[3].nextSetBit(cpt + 1)) != -1) {
            sizes[i] = this.widths[cpt] * this.heights[cpt];
            ++i;
        }
        return LowerBoundFactory.computeL_DFF_1BP(sizes, this.cwidth * this.cheight) + subsets[0].cardinality();
    }

    private final int computeL_DFF(AbstractDDFF[] ddff, BitSet selected) {
        int r = 0;
        if (selected.cardinality() > 0) {
            for (int i = 0; i < ddff.length; ++i) {
                ddff[i].setStoredSelected(selected);
            }
            r = LowerBoundFactory.computeL_DFF_1BP(ddff);
        }
        return r;
    }

    private int computeBM2(BitSet[] subsets, AbstractDDFF[] ddffw, AbstractDDFF[] ddffh) {
        return this.computeL_DFF(ddffw, subsets[1]) + this.computeL_DFF(ddffh, subsets[2]) + subsets[0].cardinality();
    }

    @Deprecated
    public int computeL_2CM_2_old() {
        int v = 0;
        for (int k = 1; k <= this.cwidth / 2; ++k) {
            for (int l = 1; l <= this.cheight / 2; ++l) {
                int l22;
                int l2;
                BitSet[] subsets = this.extractSubsets(k, l);
                int l21 = this.computeBM_1BP_1(subsets);
                int n = l2 = l21 < (l22 = this.computeBM_1BP_1(subsets)) ? l22 : l21;
                if (v >= l2) continue;
                v = l2;
            }
        }
        return v;
    }

    private void setParameter(BitSet params, int size, int capacity) {
        int k = Math.min(size + 1, capacity - size + 1);
        if (AbstractDDFF.isValidParameter(k, capacity)) {
            params.set(k);
        }
    }

    private BitSet[] selectParametersBM() {
        BitSet[] select = new BitSet[]{new BitSet(this.cwidth / 2 + 1), new BitSet(this.cheight / 2 + 1)};
        select[0].set(1);
        select[1].set(1);
        for (int i = 0; i < this.widths.length; ++i) {
            if (this.widths[i] <= this.cwidth / 2 && this.widths[i] <= this.cwidth / 2) continue;
            this.setParameter(select[0], this.widths[i], this.cwidth);
            this.setParameter(select[1], this.heights[i], this.cheight);
        }
        return select;
    }

    public int computeL_2CM_2() {
        int v = 0;
        AbstractDDFF[] ddffw = LowerBoundFactory.createDDFF(this.widths, this.cwidth, null);
        AbstractDDFF[] ddffh = LowerBoundFactory.createDDFF(this.heights, this.cheight, null);
        BitSet[] select = this.selectParametersBM();
        int k = select[0].nextSetBit(0);
        while (k >= 0) {
            int l = select[1].nextSetBit(0);
            while (l >= 0) {
                BitSet[] subsets = this.extractSubsets(k, l);
                int l2 = this.computeBM2(subsets, ddffw, ddffh);
                if (v < l2) {
                    v = l2;
                }
                l = select[1].nextSetBit(l + 1);
            }
            k = select[0].nextSetBit(k + 1);
        }
        return v;
    }

    public int computeL_2CM() {
        int lb2;
        int lb1 = this.computeL_DFF();
        return lb1 < (lb2 = this.computeL_2CM_2()) ? lb2 : lb1;
    }
}

