/*
 * Decompiled with CFR 0.152.
 */
package choco.kernel.common.opres.pack;

import choco.kernel.common.opres.pack.Bin;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;

public abstract class AbstractHeurisic1BP {
    public static final int COPY_AND_SORT = 0;
    public static final int SORT = 1;
    public static final int INCREASING = 2;
    public static final int DECREASING = 3;
    public final int[] sizes;
    public final int capacity;
    protected final List<Bin> available = new LinkedList<Bin>();
    protected final List<Bin> filled = new LinkedList<Bin>();
    private final boolean increasing;
    private final int siIndex;

    public AbstractHeurisic1BP(int[] sizes, int capacity) {
        this(sizes, capacity, 0);
    }

    public AbstractHeurisic1BP(int[] sizes, int capacity, int mode) {
        int[] nArray = this.sizes = mode == 0 ? Arrays.copyOf(sizes, sizes.length) : sizes;
        if (mode == 1 || mode == 0) {
            Arrays.sort(this.sizes);
        }
        this.increasing = mode != 3;
        this.capacity = capacity;
        this.siIndex = this.initialize();
    }

    private int initialize() {
        int k;
        if (this.increasing) {
            for (k = 0; k < this.sizes.length && this.sizes[k] == 0; ++k) {
            }
        } else {
            for (k = this.sizes.length - 1; k >= 0 && this.sizes[k] == 0; --k) {
            }
        }
        return k;
    }

    public void reset() {
        this.available.clear();
        this.filled.clear();
    }

    public abstract Bin extract(int var1);

    protected final void pack(int item, Bin bin) {
        bin.pack(item, this.sizes[item]);
        if (bin.isPackable(this.sizes[this.siIndex])) {
            this.available.add(bin);
        } else {
            this.filled.add(bin);
        }
    }

    public final int computeUB() {
        this.reset();
        if (this.increasing) {
            for (int item = this.sizes.length - 1; item >= this.siIndex; --item) {
                this.pack(item, this.extract(item));
            }
        } else {
            for (int item = 0; item < this.siIndex; ++item) {
                this.pack(item, this.extract(item));
            }
        }
        return this.filled.size() + this.available.size();
    }
}

