/*
 * Decompiled with CFR 0.152.
 */
package choco.kernel.common.opres.pack;

import choco.kernel.common.opres.pack.BestFit1BP;
import choco.kernel.common.opres.pack.FirstFit1BP;
import java.util.BitSet;

public abstract class AbstractDDFF {
    protected final int[] sizes;
    protected final int[] storedSizes;
    protected int capacity;
    protected final int storedCapacity;
    protected BitSet selected;
    private BitSet storedSelected;

    public AbstractDDFF(int[] sizes, int capacity) {
        this(sizes, capacity, null);
    }

    public AbstractDDFF(int[] sizes, int capacity, BitSet selected) {
        this.storedSizes = sizes;
        this.storedCapacity = capacity;
        this.storedSelected = selected;
        this.sizes = new int[sizes.length];
        this.reset();
    }

    public void reset() {
        this.selected = this.storedSelected == null ? null : (BitSet)this.storedSelected.clone();
    }

    private int transform(int i, int k) {
        this.sizes[i] = this.applyFunction(i, k);
        if (this.sizes[i] == 0) {
            this.selected.set(i, false);
        }
        return this.sizes[i];
    }

    public int applyFunction(int k) {
        int sum = 0;
        this.updateCapacity(k);
        if (this.selected == null) {
            this.selected = new BitSet(this.sizes.length);
            this.selected.set(0, this.sizes.length);
            for (int i = 0; i < this.sizes.length; ++i) {
                sum += this.transform(i, k);
            }
        } else {
            int i = this.selected.nextSetBit(0);
            while (i >= 0) {
                sum += this.transform(i, k);
                i = this.selected.nextSetBit(i + 1);
            }
        }
        return AbstractDDFF.round(sum, this.capacity);
    }

    protected abstract void updateCapacity(int var1);

    protected abstract int applyFunction(int var1, int var2);

    public static final boolean isValidParameter(int k, int capacity) {
        return k >= 1 && k <= capacity / 2;
    }

    public final boolean isValidParameter(int k) {
        return AbstractDDFF.isValidParameter(k, this.storedCapacity);
    }

    protected boolean setParameter(BitSet params, int k) {
        boolean r = false;
        if (this.isValidParameter(k)) {
            params.set(k);
            r = true;
        }
        return r;
    }

    protected abstract void setParameters(BitSet var1, int var2);

    public BitSet selectParameters() {
        BitSet params = new BitSet(this.capacity / 2 + 1);
        params.set(1);
        if (this.selected == null) {
            for (int i = 0; i < this.sizes.length; ++i) {
                this.setParameters(params, i);
            }
        } else {
            int i = this.selected.nextSetBit(0);
            while (i >= 0) {
                this.setParameters(params, i);
                i = this.selected.nextSetBit(i + 1);
            }
        }
        return params;
    }

    public long getSum() {
        int sum = 0;
        if (this.selected == null) {
            for (int i = 0; i < this.sizes.length; ++i) {
                sum += this.sizes[i];
            }
        } else {
            int i = this.selected.nextSetBit(0);
            while (i >= 0) {
                sum += this.sizes[i];
                i = this.selected.nextSetBit(i + 1);
            }
        }
        return sum;
    }

    public final int getCapacity() {
        return this.capacity;
    }

    public final int[] getSizes() {
        return this.sizes;
    }

    public final BitSet getSelected() {
        return this.selected;
    }

    public final void setStoredSelected(BitSet storedSelected) {
        this.storedSelected = storedSelected;
        this.selected = (BitSet)storedSelected.clone();
    }

    public final void setSelected(BitSet selected) {
        this.selected = selected;
    }

    public int computeL0() {
        return AbstractDDFF.round(this.getSum(), this.capacity);
    }

    protected static int round(double d, double div) {
        return (int)Math.ceil(d / div);
    }

    private int[] extract() {
        int[] s = new int[this.selected.cardinality()];
        int cpt = 0;
        int i = this.selected.nextSetBit(0);
        while (i >= 0) {
            s[cpt] = this.storedSizes[i];
            ++cpt;
            i = this.selected.nextSetBit(i + 1);
        }
        return s;
    }

    public final int computeUB() {
        int[] s;
        int mode;
        if (this.selected == null) {
            mode = 0;
            s = this.storedSizes;
        } else {
            mode = 1;
            s = this.extract();
        }
        BestFit1BP h1 = new BestFit1BP(s, this.storedCapacity, mode);
        FirstFit1BP h2 = new FirstFit1BP(h1.sizes, h1.capacity, 2);
        return Math.min(h1.computeUB(), h2.computeUB());
    }

    protected static final void write(StringBuilder buffer, String lab1, int[] t, String lab2, int c) {
        buffer.append(lab2).append('=').append(c).append(' ');
        buffer.append(lab1).append("={");
        for (int i = 0; i < t.length; ++i) {
            buffer.append(t[i]).append(',');
        }
        buffer.setCharAt(buffer.length() - 1, '}');
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        AbstractDDFF.write(buffer, "s", this.sizes, "c", this.capacity);
        return buffer.toString();
    }
}

