/*
 * Decompiled with CFR 0.152.
 */
package choco.kernel.common.opres.graph;

import choco.kernel.common.IDotty;
import choco.kernel.common.opres.graph.TreeNode;
import gnu.trove.TIntArrayList;
import gnu.trove.TIntProcedure;

public class GraphDTC
implements IDotty {
    public static final int ADDED = 0;
    public static final int CYCLE = 1;
    public static final int TRANSITIVE = 2;
    public static final int INTERNAL_ERROR = 3;
    public static final int EXISTING = 4;
    public final int n;
    protected int nbEdges = 0;
    protected boolean TransitiveArcAdded = true;
    protected final TreeNode[][] index;
    protected final TIntArrayList[] successors;
    protected final TIntArrayList[] predecessors;

    public GraphDTC(int n) {
        this.n = n;
        this.successors = new TIntArrayList[n];
        this.predecessors = new TIntArrayList[n];
        for (int i = 0; i < n; ++i) {
            this.successors[i] = new TIntArrayList();
            this.predecessors[i] = new TIntArrayList();
        }
        this.index = this.initIndex();
    }

    public final boolean isTransitiveArcAdded() {
        return this.TransitiveArcAdded;
    }

    public final void setTransitiveArcAdded(boolean transitiveArcAdded) {
        this.TransitiveArcAdded = transitiveArcAdded;
    }

    private final TreeNode[][] initIndex() {
        TreeNode[][] res = new TreeNode[this.n][this.n];
        for (int i = 0; i < this.n; ++i) {
            res[i][i] = new TreeNode(i);
        }
        return res;
    }

    protected final boolean isNotTransitive(int i, int j) {
        return this.index[i][j] == null;
    }

    public boolean isTransitive(int i, int j) {
        return this.index[i][j] != null;
    }

    protected final void meld(int i, int j, int u, int v) {
        this.index[i][v] = new TreeNode(v);
        this.index[i][u].addChild(this.index[i][v]);
        if (this.index[j][v] != null) {
            for (TreeNode w : this.index[j][v].copyChildren()) {
                if (this.index[i][w.index] != null) continue;
                this.meld(i, j, v, w.index);
            }
        }
    }

    public int add(int i, int j) {
        if (this.isNotTransitive(i, j)) {
            this.successors[i].add(j);
            this.predecessors[j].add(i);
            for (int u = 0; u < this.n; ++u) {
                if (this.index[u][i] == null || this.index[u][j] != null) continue;
                this.meld(u, j, i, j);
            }
            ++this.nbEdges;
            return 0;
        }
        if (this.successors[i].contains(j)) {
            return 4;
        }
        if (this.isTransitiveArcAdded()) {
            this.successors[i].add(j);
            this.predecessors[j].add(i);
            ++this.nbEdges;
        }
        return 2;
    }

    @Override
    public String toDotty() {
        return this.toDotty(true);
    }

    protected String toDotty(boolean primalOrDual) {
        TIntArrayList[] graph = primalOrDual ? this.successors : this.predecessors;
        DotProcedure proc = new DotProcedure();
        return proc.toDotty(graph);
    }

    public boolean isDisconnected(int i) {
        return !this.hasPredecessor(i) && !this.hasSuccessor(i);
    }

    public final boolean hasPredecessor(int i) {
        return !this.predecessors[i].isEmpty();
    }

    public final boolean hasSuccessor(int i) {
        return !this.successors[i].isEmpty();
    }

    public final int getNbPredecessors(int i) {
        return this.predecessors[i].size();
    }

    public final TIntArrayList getPredecessors(int i) {
        return this.predecessors[i];
    }

    public final int getNbSuccessors(int i) {
        return this.successors[i].size();
    }

    public final TIntArrayList getSuccessors(int i) {
        return this.successors[i];
    }

    public final boolean isEmpty() {
        return this.nbEdges == 0;
    }

    public final boolean[][] toTreeNodeMatrix() {
        boolean[][] r = new boolean[this.n][this.n];
        for (int i = 0; i < this.index.length; ++i) {
            for (int j = 0; j < this.index[i].length; ++j) {
                r[i][j] = this.index[i][j] != null;
            }
        }
        return r;
    }

    final class DotProcedure
    implements TIntProcedure {
        public final StringBuilder buffer = new StringBuilder();
        public int origin = 0;

        DotProcedure() {
        }

        protected String toDotty(TIntArrayList[] graph) {
            this.origin = 0;
            while (this.origin < graph.length) {
                graph[this.origin].forEach(this);
                ++this.origin;
            }
            return new String(this.buffer);
        }

        @Override
        public boolean execute(int arg0) {
            this.buffer.append(this.origin).append("->").append(arg0).append(";\n");
            return true;
        }
    }
}

