/*
 * Decompiled with CFR 0.152.
 */
package choco.kernel.common.opres.graph;

import choco.kernel.common.opres.graph.GraphDTC;
import choco.kernel.common.opres.graph.TreeNode;
import choco.kernel.common.util.ChocoUtil;
import gnu.trove.TIntArrayList;
import gnu.trove.TIntProcedure;

public class DagDTC
extends GraphDTC {
    protected final int[] orderIndex;
    protected int[] order;
    private TopoAlgoStruct topStruct;

    public DagDTC(int n) {
        super(n);
        this.order = ChocoUtil.zeroToN(n);
        this.orderIndex = ChocoUtil.zeroToN(n);
    }

    @Override
    public int add(int i, int j) {
        if (this.isNotCyclic(i, j)) {
            int val = super.add(i, j);
            if (val == 0) {
                this.fireTopologicalorder(i, j);
            }
            return val;
        }
        return 1;
    }

    protected void fireTopologicalorder(int i, int j) {
        this.computeTopologicalOrder();
    }

    public boolean remove(int i, int j) {
        boolean changes = false;
        if (this.removeEdges(i, j)) {
            for (int u = 0; u < this.n; ++u) {
                if (this.index[u][i] == null || !this.index[u][i].isChild(j)) continue;
                changes |= this.hook(u, j);
            }
        }
        return changes;
    }

    private final boolean removeEdges(int i, int j) {
        int idx = this.successors[i].lastIndexOf(j);
        if (idx != -1) {
            this.successors[i].remove(idx);
            idx = this.predecessors[j].lastIndexOf(i);
            this.predecessors[j].remove(idx);
            return true;
        }
        return false;
    }

    private final boolean hasNextNode(TreeNode node) {
        if (node.incomingIndex < this.predecessors[node.index].size()) {
            return true;
        }
        node.incomingIndex = this.predecessors[node.index].size();
        return false;
    }

    private final int nextNode(TreeNode node) {
        ++node.incomingIndex;
        return this.predecessors[node.index].get(node.incomingIndex - 1);
    }

    private final boolean hook(int i, int j) {
        TreeNode[] children;
        TreeNode tij = this.index[i][j];
        while (this.hasNextNode(tij)) {
            int x = this.nextNode(tij);
            if (this.index[i][x] == null) continue;
            tij.father.removeChild(j);
            this.index[i][x].addChild(this.index[i][j]);
            return false;
        }
        this.index[i][j].setRoot();
        this.index[i][j] = null;
        for (TreeNode u : children = tij.copyChildren()) {
            this.hook(i, u.index);
        }
        return true;
    }

    private final boolean isNotCyclic(int i, int j) {
        return this.index[j][i] == null;
    }

    public final boolean isCyclic(int i, int j) {
        return this.index[j][i] != null;
    }

    protected final void computeTopologicalOrder() {
        if (this.topStruct == null) {
            this.topStruct = new TopoAlgoStruct();
        }
        this.topStruct.reset();
        int cpt = 0;
        while (!this.topStruct.free.isEmpty()) {
            this.order[cpt] = this.topStruct.free.remove(0);
            this.orderIndex[this.order[cpt]] = cpt;
            this.successors[this.order[cpt]].forEach(this.topStruct);
            ++cpt;
        }
    }

    public final int[] getTopologicalOrderIndex() {
        return this.orderIndex;
    }

    public final int[] getTopologicalOrder() {
        return this.order;
    }

    protected class TopoAlgoStruct
    implements TIntProcedure {
        public final int[] nbPredecessors;
        public final TIntArrayList free;

        public TopoAlgoStruct() {
            this.nbPredecessors = new int[DagDTC.this.n];
            this.free = new TIntArrayList();
        }

        void reset() {
            this.free.clear();
            for (int i = 0; i < DagDTC.this.n; ++i) {
                if (DagDTC.this.predecessors[i].size() == 0) {
                    this.free.add(i);
                    continue;
                }
                this.nbPredecessors[i] = DagDTC.this.predecessors[i].size();
            }
        }

        @Override
        public boolean execute(int arg0) {
            int n = arg0;
            this.nbPredecessors[n] = this.nbPredecessors[n] - 1;
            if (this.nbPredecessors[arg0] == 0) {
                this.free.add(arg0);
            }
            return true;
        }
    }
}

