/*
 * Decompiled with CFR 0.152.
 */
package choco.kernel.common;

import choco.kernel.common.DotString;
import choco.kernel.common.IDotty;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;

public final class VizFactory {
    private static final String DOT_HEADER = "digraph g {\n\n";
    private static final String GPL_CMD = "gnuplot -persist";

    private VizFactory() {
    }

    public static File toDotty(String source) {
        return VizFactory.toDotty(new DotString(source));
    }

    public static File toDotty(IDotty ... sources) {
        return VizFactory.toDotty(VizFactory.createTempFile("dotty", ".dot"), sources);
    }

    public static File toDotty(File f, IDotty ... sources) {
        if (sources != null && sources.length > 0) {
            try {
                FileWriter fw = new FileWriter(f);
                fw.write(DOT_HEADER);
                for (IDotty s : sources) {
                    fw.write(s.toDotty());
                    fw.write(10);
                }
                fw.write("\n}");
                fw.close();
                VizFactory.created(f);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return f;
        }
        VizFactory.error("no object to draw");
        return null;
    }

    protected static File createFile(String prefix, String suffix, String contents) {
        File f = VizFactory.createTempFile(prefix, suffix);
        try {
            FileWriter fw = new FileWriter(f);
            fw.write(contents);
            fw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        VizFactory.created(f);
        return f;
    }

    public static void displayGnuplot(String curve) {
        VizFactory.displayGnuplot(VizFactory.createTempFile("gnuplot", ".gpl"));
    }

    public static void displayGnuplot(File curve) {
        File script = VizFactory.createFile("gnuplot", ".gpl", "plot '" + curve.getAbsolutePath() + "' with lines");
        VizFactory.execGnuplot(script);
    }

    public static void execGnuplot(File script) {
        VizFactory.exec(GPL_CMD, true, script);
    }

    protected static void error(String message) {
        System.err.println(message);
    }

    protected static void info(String message) {
        System.out.println(message);
    }

    protected static void created(File f) {
        VizFactory.info("creation " + f.getAbsolutePath() + " [ok]");
    }

    public static File createTempFile(String name, String suffix) {
        File f = null;
        try {
            f = File.createTempFile(name + "_", suffix);
        }
        catch (IOException e) {
            VizFactory.error("can't create temporary file");
            e.printStackTrace();
        }
        return f;
    }

    public static void launchCommand(String cmd, boolean waitFor) {
        try {
            Runtime r = Runtime.getRuntime();
            Process p = r.exec(cmd);
            if (waitFor) {
                p.waitFor();
            }
        }
        catch (Exception e) {
            System.out.println("erreur d'execution " + cmd + e.toString());
        }
    }

    public static void exec(String cmd, boolean waitFor, File data) {
        VizFactory.launchCommand(cmd + " " + data.getAbsolutePath(), waitFor);
    }
}

