/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.variables.set;

import choco.cp.solver.variables.set.SetDomainImpl;
import choco.cp.solver.variables.set.SetVarEvent;
import choco.kernel.common.util.DisposableIntIterator;
import choco.kernel.solver.ContradictionException;
import choco.kernel.solver.Solver;
import choco.kernel.solver.SolverException;
import choco.kernel.solver.variables.AbstractVar;
import choco.kernel.solver.variables.integer.IntDomainVar;
import choco.kernel.solver.variables.set.SetDomain;
import choco.kernel.solver.variables.set.SetVar;

public class SetVarImpl
extends AbstractVar
implements SetVar {
    protected SetDomainImpl domain;
    protected IntDomainVar card;

    public SetVarImpl(Solver solver, String name, int a, int b, IntDomainVar card) {
        super(solver, name);
        this.domain = new SetDomainImpl((SetVar)this, a, b);
        this.event = new SetVarEvent(this);
        this.card = card;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public SetVarImpl(Solver solver, String name, int a, int b, IntDomainVar card, int type) {
        super(solver, name);
        this.domain = new SetDomainImpl((SetVar)this, a, b);
        this.event = new SetVarEvent(this);
        if (card == null) {
            if (type == 1) {
                this.card = solver.createEnumIntVar(name, 0, b - a + 1);
                return;
            } else {
                if (type != 0) throw new SolverException("unknown type of set var " + type);
                this.card = solver.createBoundIntVar("|" + name + "|", 0, b - a + 1);
            }
            return;
        } else {
            this.card = card;
        }
    }

    public SetVarImpl(Solver solver, String name, int[] sortedValues, IntDomainVar card) {
        super(solver, name);
        this.domain = new SetDomainImpl(this, sortedValues);
        this.event = new SetVarEvent(this);
        this.card = card;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public SetVarImpl(Solver solver, String name, int[] sortedValues, IntDomainVar card, int type) {
        super(solver, name);
        this.event = new SetVarEvent(this);
        int size = sortedValues.length;
        if (card == null) {
            if (type == 1) {
                this.card = solver.createEnumIntVar("|" + name + "|", 0, size);
            } else if (type == 0) {
                this.card = solver.createBoundIntVar("|" + name + "|", 0, size);
            } else {
                if (type != 2) throw new SolverException("unknown type of set var " + type);
                this.card = solver.createBoundIntVar("|" + name + "|", size, size);
            }
        } else {
            this.card = card;
        }
        boolean constant = type == 2;
        this.domain = new SetDomainImpl((SetVar)this, sortedValues, constant);
    }

    @Override
    public IntDomainVar getCard() {
        return this.card;
    }

    @Override
    public void fail() throws ContradictionException {
        super.fail();
        this.solver.getPropagationEngine().raiseContradiction(this, 1);
    }

    @Override
    public boolean isInstantiated() {
        return this.domain.isInstantiated();
    }

    @Override
    public void setValIn(int x) throws ContradictionException {
        this.addToKernel(x, -1);
    }

    @Override
    public void setValOut(int x) throws ContradictionException {
        this.remFromEnveloppe(x, -1);
    }

    @Override
    public boolean isInDomainKernel(int x) {
        return this.domain.getKernelDomain().contains(x);
    }

    @Override
    public boolean isInDomainEnveloppe(int x) {
        return this.domain.getEnveloppeDomain().contains(x);
    }

    @Override
    public SetDomain getDomain() {
        return this.domain;
    }

    @Override
    public boolean canBeEqualTo(SetVar x) {
        return false;
    }

    @Override
    public int getKernelDomainSize() {
        return this.domain.getKernelDomain().getSize();
    }

    @Override
    public int getEnveloppeDomainSize() {
        return this.domain.getEnveloppeDomain().getSize();
    }

    @Override
    public int getEnveloppeInf() {
        return this.domain.getEnveloppeDomain().getFirstVal();
    }

    @Override
    public int getEnveloppeSup() {
        return this.domain.getEnveloppeDomain().getLastVal();
    }

    @Override
    public int getKernelInf() {
        return this.domain.getKernelDomain().getFirstVal();
    }

    @Override
    public int getKernelSup() {
        return this.domain.getKernelDomain().getLastVal();
    }

    @Override
    public int[] getValue() {
        int[] val = new int[this.getKernelDomainSize()];
        DisposableIntIterator it = this.domain.getKernelIterator();
        int i = 0;
        while (it.hasNext()) {
            val[i] = it.next();
            ++i;
        }
        return val;
    }

    @Override
    public void setVal(int[] val) throws ContradictionException {
        this.instantiate(val, -1);
    }

    @Override
    public boolean addToKernel(int x, int idx) throws ContradictionException {
        return this.domain.addToKernel(x, idx);
    }

    @Override
    public boolean remFromEnveloppe(int x, int idx) throws ContradictionException {
        return this.domain.remFromEnveloppe(x, idx);
    }

    @Override
    public boolean instantiate(int[] x, int idx) throws ContradictionException {
        return this.domain.instantiate(x, idx);
    }

    @Override
    public String pretty() {
        return this.toString();
    }

    @Override
    public String toString() {
        return this.name + " " + this.domain.toString();
    }

    @Override
    public Solver getSolver() {
        return this.solver;
    }

    @Override
    public void setSolver(Solver solver) {
        this.solver = solver;
    }
}

