/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.variables.set;

import choco.cp.solver.variables.set.SetVarImpl;
import choco.kernel.common.util.DisposableIntIterator;
import choco.kernel.common.util.IntIterator;
import choco.kernel.memory.PartiallyStoredIntVector;
import choco.kernel.memory.PartiallyStoredVector;
import choco.kernel.solver.ContradictionException;
import choco.kernel.solver.constraints.SConstraint;
import choco.kernel.solver.constraints.set.SetSConstraint;
import choco.kernel.solver.propagation.VarEvent;
import choco.kernel.solver.variables.set.SetVar;
import java.util.logging.Level;

public class SetVarEvent
extends VarEvent<SetVarImpl> {
    public static final int REMENV = 0;
    public static final int ADDKER = 1;
    public static final int INSTSET = 2;
    public static final int ENVEVENT = 1;
    public static final int KEREVENT = 2;
    public static final int BOUNDSEVENT = 3;
    public static final int INSTSETEVENT = 4;

    public SetVarEvent(SetVarImpl var) {
        super(var);
        this.eventType = 0;
    }

    public String toString() {
        return "VarEvt(" + ((SetVarImpl)this.modifiedVar).toString() + ")[" + this.eventType + ":" + ((this.eventType & 1) != 0 ? "E" : "") + ((this.eventType & 2) != 0 ? "K" : "") + ((this.eventType & 4) != 0 ? "X" : "") + "]";
    }

    @Override
    public void clear() {
        this.eventType = 0;
        ((SetVarImpl)this.modifiedVar).getDomain().getEnveloppeDomain().clearDeltaDomain();
        ((SetVarImpl)this.modifiedVar).getDomain().getKernelDomain().clearDeltaDomain();
    }

    @Override
    protected void freeze() {
        ((SetVarImpl)this.modifiedVar).getDomain().getEnveloppeDomain().freezeDeltaDomain();
        ((SetVarImpl)this.modifiedVar).getDomain().getKernelDomain().freezeDeltaDomain();
        this.cause = -2;
        this.eventType = 0;
    }

    @Override
    protected boolean release() {
        return ((SetVarImpl)this.modifiedVar).getDomain().getEnveloppeDomain().releaseDeltaDomain() && ((SetVarImpl)this.modifiedVar).getDomain().getKernelDomain().releaseDeltaDomain();
    }

    public boolean getReleased() {
        return ((SetVarImpl)this.modifiedVar).getDomain().getEnveloppeDomain().getReleasedDeltaDomain() && ((SetVarImpl)this.modifiedVar).getDomain().getKernelDomain().getReleasedDeltaDomain();
    }

    public IntIterator getEnvEventIterator() {
        return ((SetVarImpl)this.modifiedVar).getDomain().getEnveloppeDomain().getDeltaIterator();
    }

    public IntIterator getKerEventIterator() {
        return ((SetVarImpl)this.modifiedVar).getDomain().getKernelDomain().getDeltaIterator();
    }

    @Override
    public boolean propagateEvent() throws ContradictionException {
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("propagate " + this.toString());
        }
        int evtType = this.eventType;
        int evtCause = this.cause;
        this.freeze();
        if (evtType >= 4) {
            this.propagateInstEvent(evtCause);
        } else if (evtType <= 3) {
            if (evtType == 1) {
                this.propagateEnveloppeEvents(evtCause);
            } else if (evtType == 2) {
                this.propagateKernelEvents(evtCause);
            } else if (evtType == 3) {
                this.propagateKernelEvents(evtCause);
                this.propagateEnveloppeEvents(evtCause);
            }
        }
        return this.release();
    }

    public void propagateInstEvent(int evtCause) throws ContradictionException {
        SetVar v = (SetVar)this.getModifiedVar();
        PartiallyStoredVector<SConstraint> constraints = v.getConstraintVector();
        PartiallyStoredIntVector indices = v.getIndexVector();
        DisposableIntIterator cit = constraints.getIndexIterator();
        while (cit.hasNext()) {
            SetSConstraint c;
            int idx = cit.next();
            if (idx == evtCause || !(c = (SetSConstraint)constraints.get(idx)).isActive()) continue;
            int i = indices.get(idx);
            c.awakeOnInst(i);
        }
    }

    public void propagateKernelEvents(int evtCause) throws ContradictionException {
        SetVar v = (SetVar)this.getModifiedVar();
        PartiallyStoredVector<SConstraint> constraints = v.getConstraintVector();
        PartiallyStoredIntVector indices = v.getIndexVector();
        DisposableIntIterator cit = constraints.getIndexIterator();
        while (cit.hasNext()) {
            SetSConstraint c;
            int idx = cit.next();
            if (idx == evtCause || !(c = (SetSConstraint)constraints.get(idx)).isActive()) continue;
            int i = indices.get(idx);
            c.awakeOnkerAdditions(i, this.getKerEventIterator());
        }
    }

    public void propagateEnveloppeEvents(int evtCause) throws ContradictionException {
        SetVar v = (SetVar)this.getModifiedVar();
        PartiallyStoredVector<SConstraint> constraints = v.getConstraintVector();
        PartiallyStoredIntVector indices = v.getIndexVector();
        DisposableIntIterator cit = constraints.getIndexIterator();
        while (cit.hasNext()) {
            SetSConstraint c;
            int idx = cit.next();
            if (idx == evtCause || !(c = (SetSConstraint)constraints.get(idx)).isActive()) continue;
            int i = indices.get(idx);
            c.awakeOnEnvRemovals(i, this.getEnvEventIterator());
        }
    }
}

