/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.variables.set;

import choco.cp.solver.variables.set.BitSetEnumeratedDomain;
import choco.kernel.common.util.DisposableIntIterator;
import choco.kernel.solver.ContradictionException;
import choco.kernel.solver.Solver;
import choco.kernel.solver.variables.set.SetDomain;
import choco.kernel.solver.variables.set.SetSubDomain;
import choco.kernel.solver.variables.set.SetVar;
import java.util.Arrays;

public class SetDomainImpl
implements SetDomain {
    public Solver solver;
    protected SetVar variable;
    private int capacity;
    private BitSetEnumeratedDomain kernel;
    private BitSetEnumeratedDomain enveloppe;

    public SetDomainImpl(SetVar v, int a, int b) {
        this.variable = v;
        this.solver = v.getSolver();
        this.capacity = b - a + 1;
        this.kernel = new BitSetEnumeratedDomain(v, a, b, false);
        this.enveloppe = new BitSetEnumeratedDomain(v, a, b, true);
    }

    public SetDomainImpl(SetVar v, int[] sortedValues) {
        this.variable = v;
        this.solver = v.getSolver();
        this.capacity = sortedValues.length;
        this.kernel = new BitSetEnumeratedDomain(v, sortedValues, false);
        this.enveloppe = new BitSetEnumeratedDomain(v, sortedValues, true);
    }

    public SetDomainImpl(SetVar v, int[] sortedValues, boolean constant) {
        this.variable = v;
        this.solver = v.getSolver();
        this.capacity = sortedValues.length;
        if (sortedValues != null && sortedValues.length > 0) {
            this.kernel = new BitSetEnumeratedDomain(v, sortedValues, constant);
            this.enveloppe = new BitSetEnumeratedDomain(v, sortedValues, true);
        } else {
            this.kernel = BitSetEnumeratedDomain.empty(v);
            this.enveloppe = BitSetEnumeratedDomain.empty(v);
        }
    }

    @Override
    public SetSubDomain getKernelDomain() {
        return this.kernel;
    }

    @Override
    public SetSubDomain getEnveloppeDomain() {
        return this.enveloppe;
    }

    public boolean addToKernel(int x) {
        this.kernel.add(x);
        return true;
    }

    public boolean isInstantiated() {
        return this.kernel.getSize() == this.enveloppe.getSize();
    }

    public boolean isInstantiatedTo(int[] setVal) {
        if (setVal.length == this.kernel.getSize() && setVal.length == this.enveloppe.getSize()) {
            for (int i = 0; i < setVal.length; ++i) {
                if (this.kernel.contains(setVal[i])) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean canBeInstantiatedTo(int[] setVal) {
        if (this.kernel.getSize() <= setVal.length && this.enveloppe.getSize() >= setVal.length) {
            int i;
            Arrays.sort(setVal);
            for (i = 0; i < setVal.length; ++i) {
                if (this.enveloppe.contains(setVal[i])) continue;
                return false;
            }
            i = this.kernel.getFirstVal();
            while (i >= 0) {
                if (Arrays.binarySearch(setVal, i) < 0) {
                    return false;
                }
                i = this.kernel.getNextValue(i);
            }
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer("{Env[");
        int count = 0;
        DisposableIntIterator it = this.getEnveloppeIterator();
        while (it.hasNext()) {
            int val = it.next();
            if (++count > 1) {
                buf.append(",");
            }
            buf.append(val);
        }
        buf.append("], Ker[");
        count = 0;
        DisposableIntIterator it2 = this.getKernelIterator();
        while (it2.hasNext()) {
            int val = it2.next();
            if (++count > 1) {
                buf.append(",");
            }
            buf.append(val);
        }
        buf.append("]}");
        return buf.toString();
    }

    @Override
    public String pretty() {
        return this.toString();
    }

    protected boolean remFromEnveloppe(int x, int idx) throws ContradictionException {
        if (this._remFromEnveloppe(x, idx)) {
            if (this.isInstantiated()) {
                this.solver.getPropagationEngine().postInstSet(this.variable, -1);
            } else {
                this.solver.getPropagationEngine().postRemEnv(this.variable, idx);
            }
            return true;
        }
        return false;
    }

    protected boolean addToKernel(int x, int idx) throws ContradictionException {
        if (this._addToKernel(x, idx)) {
            if (this.isInstantiated()) {
                this.solver.getPropagationEngine().postInstSet(this.variable, -1);
            } else {
                this.solver.getPropagationEngine().postAddKer(this.variable, idx);
            }
            return true;
        }
        return false;
    }

    protected boolean instantiate(int[] x, int idx) throws ContradictionException {
        if (this._instantiate(x, idx)) {
            this.solver.getPropagationEngine().postInstSet(this.variable, idx);
            return true;
        }
        return false;
    }

    protected boolean _remFromEnveloppe(int x, int idx) throws ContradictionException {
        if (this.kernel.contains(x)) {
            if (idx == -1) {
                this.getSolver().getPropagationEngine().raiseContradiction(this.variable, 1);
            } else {
                this.getSolver().getPropagationEngine().raiseContradiction(this.variable.getConstraintVector().get(idx), 2);
            }
            return true;
        }
        if (this.enveloppe.contains(x)) {
            this.enveloppe.remove(x);
            return true;
        }
        return false;
    }

    protected boolean _addToKernel(int x, int idx) throws ContradictionException {
        if (!this.enveloppe.contains(x)) {
            if (idx == -1) {
                this.getSolver().getPropagationEngine().raiseContradiction(this.variable, 1);
            } else {
                this.getSolver().getPropagationEngine().raiseContradiction(this.variable.getConstraintVector().get(idx), 2);
            }
            return true;
        }
        if (!this.kernel.contains(x)) {
            this.kernel.add(x);
            return true;
        }
        return false;
    }

    protected boolean _instantiate(int[] values, int idx) throws ContradictionException {
        int i;
        if (this.isInstantiated()) {
            if (!this.isInstantiatedTo(values)) {
                if (idx == -1) {
                    this.getSolver().getPropagationEngine().raiseContradiction(this.variable, 1);
                } else {
                    this.getSolver().getPropagationEngine().raiseContradiction(this.variable.getConstraintVector().get(idx), 2);
                }
                return true;
            }
            return true;
        }
        if (!this.canBeInstantiatedTo(values)) {
            if (idx == -1) {
                this.getSolver().getPropagationEngine().raiseContradiction(this.variable, 1);
            } else {
                this.getSolver().getPropagationEngine().raiseContradiction(this.variable.getConstraintVector().get(idx), 2);
            }
            return true;
        }
        for (i = 0; i < values.length; ++i) {
            this.kernel.add(values[i]);
        }
        i = this.enveloppe.getFirstVal();
        while (i >= 0) {
            if (!this.kernel.contains(i)) {
                this.enveloppe.remove(i);
            }
            i = this.enveloppe.getNextValue(i);
        }
        return true;
    }

    @Override
    public DisposableIntIterator getKernelIterator() {
        return new SetDomainIterator(this.kernel);
    }

    @Override
    public DisposableIntIterator getEnveloppeIterator() {
        return new SetDomainIterator(this.enveloppe);
    }

    @Override
    public DisposableIntIterator getOpenDomainIterator() {
        return new SetOpenDomainIterator(this.enveloppe, this.kernel);
    }

    @Override
    public Solver getSolver() {
        return this.solver;
    }

    @Override
    public void setSolver(Solver solver) {
        this.solver = solver;
    }

    protected static class SetOpenDomainIterator
    extends DisposableIntIterator {
        protected BitSetEnumeratedDomain envdomain;
        protected BitSetEnumeratedDomain kerdomain;
        protected int currentValue = Integer.MIN_VALUE;
        protected int nbValueToBeIterated = Integer.MAX_VALUE;

        private SetOpenDomainIterator(BitSetEnumeratedDomain dom1, BitSetEnumeratedDomain dom2) {
            this.init(dom1, dom2);
        }

        public void init(BitSetEnumeratedDomain dom1, BitSetEnumeratedDomain dom2) {
            super.init();
            this.envdomain = dom1;
            this.kerdomain = dom2;
            this.currentValue = Integer.MIN_VALUE;
            this.nbValueToBeIterated = dom1.getSize() - dom2.getSize();
        }

        @Override
        public boolean hasNext() {
            return this.nbValueToBeIterated > 0;
        }

        @Override
        public int next() {
            int i;
            int n = i = this.currentValue == Integer.MIN_VALUE ? this.envdomain.getFirstVal() : this.envdomain.getNextValue(this.currentValue);
            while (i >= 0) {
                if (!this.kerdomain.contains(i)) {
                    this.currentValue = i;
                    break;
                }
                i = this.envdomain.getNextValue(i);
            }
            --this.nbValueToBeIterated;
            return this.currentValue;
        }

        @Override
        public void remove() {
            if (this.currentValue == Integer.MIN_VALUE) {
                throw new IllegalStateException();
            }
            throw new UnsupportedOperationException();
        }
    }

    protected static class SetDomainIterator
    extends DisposableIntIterator {
        protected BitSetEnumeratedDomain domain;
        protected int currentValue = Integer.MIN_VALUE;

        private SetDomainIterator(BitSetEnumeratedDomain dom) {
            this.init(dom);
        }

        public void init(BitSetEnumeratedDomain dom) {
            super.init();
            this.domain = dom;
            this.currentValue = Integer.MIN_VALUE;
        }

        @Override
        public boolean hasNext() {
            if (this.domain.getSize() == 0) {
                return false;
            }
            return Integer.MIN_VALUE == this.currentValue ? true : this.currentValue < this.domain.getLastVal();
        }

        @Override
        public int next() {
            this.currentValue = Integer.MIN_VALUE == this.currentValue ? this.domain.getFirstVal() : this.domain.getNextValue(this.currentValue);
            return this.currentValue;
        }

        @Override
        public void remove() {
            if (this.currentValue == Integer.MIN_VALUE) {
                throw new IllegalStateException();
            }
            throw new UnsupportedOperationException();
        }
    }
}

