/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.variables.set;

import choco.kernel.common.util.IntIterator;
import choco.kernel.memory.IEnvironment;
import choco.kernel.memory.IStateBitSet;
import choco.kernel.memory.IStateInt;
import choco.kernel.solver.Solver;
import choco.kernel.solver.variables.set.SetSubDomain;
import choco.kernel.solver.variables.set.SetVar;
import java.util.logging.Logger;

public class BitSetEnumeratedDomain
implements SetSubDomain {
    protected static final Logger logger = Logger.getLogger("choco.kernel.solver.propagation");
    public Solver solver;
    protected final int offset;
    protected IStateInt size;
    protected IStateBitSet contents;
    private int capacity;
    protected int[] chain;
    protected int firstIndexToBePropagated;
    protected int firstIndexBeingPropagated;

    public BitSetEnumeratedDomain(SetVar v, int a, int b, boolean full) {
        this.solver = v.getSolver();
        IEnvironment env = this.solver.getEnvironment();
        this.capacity = b - a + 1;
        this.offset = a;
        this.size = full ? env.makeInt(this.capacity) : env.makeInt(0);
        this.contents = env.makeBitSet(this.capacity);
        if (full) {
            for (int i = 0; i < this.capacity; ++i) {
                this.contents.set(i);
            }
        }
        this.chain = new int[this.capacity];
        this.firstIndexToBePropagated = -1;
        this.firstIndexBeingPropagated = -1;
    }

    public BitSetEnumeratedDomain(SetVar v, int[] sortedValues, boolean full) {
        this.solver = v.getSolver();
        IEnvironment env = this.solver.getEnvironment();
        int a = sortedValues[0];
        int b = sortedValues[sortedValues.length - 1];
        this.capacity = b - a + 1;
        this.offset = a;
        this.size = full ? env.makeInt(sortedValues.length) : env.makeInt(0);
        this.contents = env.makeBitSet(this.capacity);
        if (full) {
            for (int i = 0; i < sortedValues.length; ++i) {
                this.contents.set(sortedValues[i] - a);
            }
        }
        this.chain = new int[this.capacity];
        this.firstIndexToBePropagated = -1;
        this.firstIndexBeingPropagated = -1;
    }

    private BitSetEnumeratedDomain(SetVar v) {
        this.solver = v.getSolver();
        IEnvironment env = this.solver.getEnvironment();
        this.capacity = 0;
        this.offset = 0;
        this.size = env.makeInt(0);
        this.contents = env.makeBitSet(this.capacity);
        this.chain = new int[this.capacity];
        this.firstIndexToBePropagated = -1;
        this.firstIndexBeingPropagated = -1;
    }

    public static BitSetEnumeratedDomain empty(SetVar v) {
        return new BitSetEnumeratedDomain(v);
    }

    @Override
    public int getFirstVal() {
        if (this.size.get() > 0) {
            return this.contents.nextSetBit(0) + this.offset;
        }
        return -1;
    }

    @Override
    public int getLastVal() {
        if (this.size.get() > 0) {
            return this.contents.prevSetBit(this.capacity - 1) + this.offset;
        }
        return -1;
    }

    @Override
    public boolean contains(int x) {
        int i = x - this.offset;
        return i >= 0 && i < this.capacity && this.contents.get(i);
    }

    @Override
    public boolean remove(int x) {
        int i = x - this.offset;
        if (this.contents.get(i)) {
            this.removeIndex(i);
            return true;
        }
        return false;
    }

    private void removeIndex(int i) {
        if (i == this.firstIndexToBePropagated) {
            logger.severe("RemoveIndex BIZARRE !!!!!!!!!!!!");
        }
        this.contents.clear(i);
        this.chain[i] = this.firstIndexToBePropagated;
        this.firstIndexToBePropagated = i;
        if (this.contents.get(i)) {
            logger.severe("etrange etrange");
        }
        this.size.add(-1);
    }

    public boolean add(int x) {
        int i = x - this.offset;
        if (!this.contents.get(i)) {
            this.addIndex(i);
            return true;
        }
        return false;
    }

    private void addIndex(int i) {
        if (i == this.firstIndexToBePropagated) {
            logger.severe("AddIndex BIZARRE !!!!!!!!!!!!");
        }
        this.contents.set(i);
        this.chain[i] = this.firstIndexToBePropagated;
        this.firstIndexToBePropagated = i;
        if (!this.contents.get(i)) {
            logger.severe("etrange etrange");
        }
        this.size.add(1);
    }

    @Override
    public int getSize() {
        return this.size.get();
    }

    public int getNextValue(int x) {
        int i = x - this.offset;
        int val = this.contents.nextSetBit(i + 1);
        if (val > 0) {
            return val + this.offset;
        }
        return -1;
    }

    public int getPrevValue(int x) {
        int i = x - this.offset;
        int val = this.contents.prevSetBit(i - 1);
        if (val > 0) {
            return val + this.offset;
        }
        return -1;
    }

    public boolean hasNextValue(int x) {
        int i = x - this.offset;
        return this.contents.nextSetBit(i + 1) != -1;
    }

    public boolean hasPrevValue(int x) {
        int i = x - this.offset;
        return this.contents.prevSetBit(i - 1) != -1;
    }

    @Override
    public IntIterator getDeltaIterator() {
        return new DeltaDomainIterator(this);
    }

    @Override
    public void freezeDeltaDomain() {
        if (this.firstIndexBeingPropagated == -1) {
            this.firstIndexBeingPropagated = this.firstIndexToBePropagated;
            this.firstIndexToBePropagated = -1;
        }
    }

    @Override
    public boolean releaseDeltaDomain() {
        if (this.firstIndexBeingPropagated == -1) {
            this.firstIndexToBePropagated = -1;
            return true;
        }
        this.firstIndexBeingPropagated = -1;
        return this.firstIndexToBePropagated == -1;
    }

    @Override
    public boolean getReleasedDeltaDomain() {
        return this.firstIndexBeingPropagated == -1 && this.firstIndexToBePropagated == -1;
    }

    @Override
    public void clearDeltaDomain() {
        this.firstIndexBeingPropagated = -1;
        this.firstIndexToBePropagated = -1;
    }

    protected class DeltaDomainIterator
    implements IntIterator {
        protected BitSetEnumeratedDomain domain;
        protected int currentIndex = -1;

        private DeltaDomainIterator(BitSetEnumeratedDomain dom) {
            this.domain = dom;
            this.currentIndex = -1;
        }

        @Override
        public boolean hasNext() {
            if (this.currentIndex == -1) {
                return BitSetEnumeratedDomain.this.firstIndexBeingPropagated != -1;
            }
            return BitSetEnumeratedDomain.this.chain[this.currentIndex] != -1;
        }

        @Override
        public int next() {
            this.currentIndex = this.currentIndex == -1 ? BitSetEnumeratedDomain.this.firstIndexBeingPropagated : BitSetEnumeratedDomain.this.chain[this.currentIndex];
            return this.currentIndex + BitSetEnumeratedDomain.this.offset;
        }

        @Override
        public void remove() {
            if (this.currentIndex == -1) {
                throw new IllegalStateException();
            }
            throw new UnsupportedOperationException();
        }
    }
}

