/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.variables.real;

import choco.cp.solver.propagation.RealVarEvent;
import choco.cp.solver.variables.real.RealDomainImpl;
import choco.kernel.solver.ContradictionException;
import choco.kernel.solver.Solver;
import choco.kernel.solver.SolverException;
import choco.kernel.solver.constraints.real.RealExp;
import choco.kernel.solver.variables.AbstractVar;
import choco.kernel.solver.variables.real.RealDomain;
import choco.kernel.solver.variables.real.RealInterval;
import choco.kernel.solver.variables.real.RealIntervalConstant;
import choco.kernel.solver.variables.real.RealMath;
import choco.kernel.solver.variables.real.RealVar;
import java.util.List;
import java.util.Set;

public class RealVarImpl
extends AbstractVar
implements RealVar {
    protected RealDomain domain;

    public RealVarImpl(Solver solver, String name, double a, double b, int domaintype) {
        super(solver, name);
        if (domaintype != 0) {
            throw new SolverException("Unknown real domain");
        }
        this.domain = new RealDomainImpl(this, a, b);
        this.event = new RealVarEvent(this);
    }

    @Override
    public String toString() {
        return this.name + "[" + this.getInf() + "," + this.getSup() + "]";
    }

    @Override
    public String pretty() {
        return this.toString();
    }

    @Override
    public RealInterval getValue() {
        return new RealIntervalConstant(this.getInf(), this.getSup());
    }

    @Override
    public RealDomain getDomain() {
        return this.domain;
    }

    @Override
    public void silentlyAssign(RealInterval i) {
        this.domain.silentlyAssign(i);
    }

    @Override
    public double getInf() {
        return this.domain.getInf();
    }

    @Override
    public double getSup() {
        return this.domain.getSup();
    }

    @Override
    public void intersect(RealInterval interval) throws ContradictionException {
        this.domain.intersect(interval);
    }

    @Override
    public void intersect(RealInterval interval, int index) throws ContradictionException {
        this.domain.intersect(interval, index);
    }

    @Override
    public void fail() throws ContradictionException {
        super.fail();
        this.solver.getPropagationEngine().raiseContradiction(this, 3);
    }

    @Override
    public boolean isInstantiated() {
        return RealMath.isCanonical(this, this.solver.getPrecision());
    }

    @Override
    public void tighten() {
    }

    @Override
    public void project() {
    }

    @Override
    public List<RealExp> subExps(List<RealExp> l) {
        l.add(this);
        return l;
    }

    @Override
    public Set<RealVar> collectVars(Set<RealVar> s) {
        s.add(this);
        return s;
    }

    @Override
    public boolean isolate(RealVar var, List<RealExp> wx, List<RealExp> wox) {
        return this == var;
    }

    @Override
    public Solver getSolver() {
        return this.solver;
    }

    @Override
    public void setSolver(Solver solver) {
        this.solver = solver;
    }
}

