/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.variables.real;

import choco.kernel.memory.IEnvironment;
import choco.kernel.memory.IStateDouble;
import choco.kernel.solver.ContradictionException;
import choco.kernel.solver.Solver;
import choco.kernel.solver.variables.real.RealDomain;
import choco.kernel.solver.variables.real.RealInterval;
import choco.kernel.solver.variables.real.RealVar;

public class RealDomainImpl
implements RealDomain {
    public Solver solver;
    protected double currentInfPropagated = Double.NEGATIVE_INFINITY;
    protected double currentSupPropagated = Double.POSITIVE_INFINITY;
    protected IStateDouble inf;
    protected IStateDouble sup;
    protected RealVar variable;

    public RealDomainImpl(RealVar v, double a, double b) {
        this.variable = v;
        this.solver = v.getSolver();
        IEnvironment env = this.solver.getEnvironment();
        this.inf = env.makeFloat(a);
        this.sup = env.makeFloat(b);
    }

    public String toString() {
        return super.toString() + ": [" + this.getInf() + ", " + this.getSup() + "]";
    }

    @Override
    public String pretty() {
        return this.toString();
    }

    @Override
    public double getInf() {
        return this.inf.get();
    }

    @Override
    public double getSup() {
        return this.sup.get();
    }

    @Override
    public void intersect(RealInterval interval) throws ContradictionException {
        this.intersect(interval, -1);
    }

    @Override
    public void intersect(RealInterval interval, int index) throws ContradictionException {
        boolean toAwake;
        if (interval.getInf() > this.getSup() || interval.getSup() < this.getInf()) {
            this.getSolver().getPropagationEngine().raiseContradiction(this, 3);
        }
        double old_width = this.getSup() - this.getInf();
        double new_width = Math.min(interval.getSup(), this.getSup()) - Math.max(interval.getInf(), this.getInf());
        boolean bl = toAwake = this.variable.getSolver().getPrecision() / 100.0 <= old_width && new_width < old_width * this.variable.getSolver().getReduction();
        if (interval.getInf() > this.getInf()) {
            if (toAwake) {
                this.solver.getPropagationEngine().postUpdateInf(this.variable, index);
            }
            this.inf.set(interval.getInf());
        }
        if (interval.getSup() < this.getSup()) {
            if (toAwake) {
                this.solver.getPropagationEngine().postUpdateSup(this.variable, index);
            }
            this.sup.set(interval.getSup());
        }
    }

    @Override
    public void clearDeltaDomain() {
        this.currentInfPropagated = Double.NEGATIVE_INFINITY;
        this.currentSupPropagated = Double.POSITIVE_INFINITY;
    }

    @Override
    public boolean releaseDeltaDomain() {
        boolean noNewUpdate = this.getInf() == this.currentInfPropagated && this.getSup() == this.currentSupPropagated;
        this.currentInfPropagated = Double.NEGATIVE_INFINITY;
        this.currentSupPropagated = Double.POSITIVE_INFINITY;
        return noNewUpdate;
    }

    @Override
    public void freezeDeltaDomain() {
        this.currentInfPropagated = this.getInf();
        this.currentSupPropagated = this.getSup();
    }

    @Override
    public boolean getReleasedDeltaDomain() {
        return true;
    }

    @Override
    public void silentlyAssign(RealInterval i) {
        this.inf.set(i.getInf());
        this.sup.set(i.getSup());
    }

    @Override
    public Solver getSolver() {
        return this.solver;
    }

    @Override
    public void setSolver(Solver solver) {
        this.solver = solver;
    }
}

