/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.variables.integer;

import choco.cp.solver.variables.integer.AbstractIntDomain;
import choco.cp.solver.variables.integer.IntDomainVarImpl;
import choco.kernel.common.util.DisposableIntIterator;
import choco.kernel.memory.IEnvironment;
import choco.kernel.memory.IStateInt;
import choco.kernel.memory.IStateIntVector;
import java.util.Random;

public class LinkedIntDomain
extends AbstractIntDomain {
    protected static Random random = new Random(System.currentTimeMillis());
    protected final IStateIntVector nextIndex;
    protected final IStateIntVector prevIndex;
    protected final IStateInt lowerBound;
    protected final IStateInt upperBound;
    protected final IStateInt size;
    protected final int offset;
    protected int[] chain;
    protected int firstIndexToBePropagated;
    protected int firstIndexBeingPropagated;

    public LinkedIntDomain(IntDomainVarImpl v, int a, int b) {
        this.variable = v;
        this.solver = v.getSolver();
        IEnvironment env = this.solver.getEnvironment();
        this.offset = a;
        this.lowerBound = env.makeInt(a);
        this.upperBound = env.makeInt(b);
        int size = b - a + 1;
        this.size = env.makeInt(size);
        int[] prevIndices = new int[size];
        int[] nextIndices = new int[size];
        for (int i = 0; i < nextIndices.length; ++i) {
            nextIndices[i] = (i + 1) % size;
            prevIndices[i] = (i - 1 + size) % size;
        }
        this.nextIndex = env.makeIntVector(nextIndices);
        this.prevIndex = env.makeIntVector(prevIndices);
        this.chain = new int[size];
        this.firstIndexToBePropagated = -1;
        this.firstIndexBeingPropagated = -1;
    }

    public LinkedIntDomain(IntDomainVarImpl v, int[] sortedValues) {
        this.variable = v;
        this.solver = v.getSolver();
        IEnvironment env = this.solver.getEnvironment();
        this.offset = sortedValues[0];
        this.lowerBound = env.makeInt(sortedValues[0]);
        this.upperBound = env.makeInt(sortedValues[sortedValues.length - 1]);
        int size = sortedValues.length;
        this.size = env.makeInt(size);
        int[] prevIndices = new int[size];
        int[] nextIndices = new int[size];
        for (int i = 0; i < sortedValues.length; ++i) {
            nextIndices[i] = (i + 1) % sortedValues.length;
            prevIndices[i] = (i - 1 + sortedValues.length) % sortedValues.length;
        }
        this.nextIndex = env.makeIntVector(nextIndices);
        this.prevIndex = env.makeIntVector(prevIndices);
        this.chain = new int[size];
        this.firstIndexToBePropagated = -1;
        this.firstIndexBeingPropagated = -1;
    }

    protected int indexToValue(int index) {
        return index + this.offset;
    }

    protected int valueToIndex(int value) {
        return value - this.offset;
    }

    protected void removeIndex(int indexToRemove) {
        this.nextIndex.set(indexToRemove, -1);
        this.prevIndex.set(indexToRemove, -1);
        this.chain[indexToRemove] = this.firstIndexToBePropagated;
        this.firstIndexToBePropagated = indexToRemove;
        this.size.add(-1);
    }

    @Override
    public int getInf() {
        return this.lowerBound.get();
    }

    @Override
    public int getSup() {
        return this.upperBound.get();
    }

    @Override
    public boolean contains(int x) {
        int xIndex = this.valueToIndex(x);
        if (xIndex < 0 || xIndex >= this.nextIndex.size()) {
            return false;
        }
        return this.nextIndex.get(xIndex) != -1;
    }

    @Override
    public int updateInf(int x) {
        int xIndex = this.valueToIndex(x);
        int currentInf = this.valueToIndex(this.lowerBound.get());
        int sup = this.valueToIndex(this.upperBound.get());
        while (currentInf < xIndex && currentInf <= sup) {
            int next = this.nextIndex.get(currentInf);
            this.removeIndex(currentInf);
            currentInf = next;
        }
        this.prevIndex.set(currentInf, sup);
        this.nextIndex.set(sup, currentInf);
        this.lowerBound.set(this.indexToValue(currentInf));
        return this.indexToValue(currentInf);
    }

    @Override
    public int updateSup(int x) {
        int xIndex = this.valueToIndex(x);
        int currentSup = this.valueToIndex(this.upperBound.get());
        int inf = this.valueToIndex(this.lowerBound.get());
        while (currentSup > xIndex) {
            int prev = this.prevIndex.get(currentSup);
            this.removeIndex(currentSup);
            currentSup = prev;
        }
        this.prevIndex.set(inf, currentSup);
        this.nextIndex.set(currentSup, inf);
        this.upperBound.set(this.indexToValue(currentSup));
        return this.indexToValue(currentSup);
    }

    @Override
    public void restrict(int x) {
        int xIndex = this.valueToIndex(x);
        int currentInf = this.valueToIndex(this.lowerBound.get());
        int currentSup = this.valueToIndex(this.upperBound.get());
        while (currentInf < xIndex) {
            int next = this.nextIndex.get(currentInf);
            this.removeIndex(currentInf);
            currentInf = next;
        }
        while (currentSup > xIndex) {
            int prev = this.prevIndex.get(currentSup);
            this.removeIndex(currentSup);
            currentSup = prev;
        }
        this.prevIndex.set(xIndex, xIndex);
        this.nextIndex.set(xIndex, xIndex);
        this.lowerBound.set(x);
        this.upperBound.set(x);
    }

    @Override
    public boolean remove(int x) {
        if (!this.contains(x)) {
            return false;
        }
        int xIndex = this.valueToIndex(x);
        int next = this.nextIndex.get(xIndex);
        int prev = this.prevIndex.get(xIndex);
        if (x == this.lowerBound.get()) {
            this.lowerBound.set(this.indexToValue(next));
        }
        if (x == this.upperBound.get()) {
            this.upperBound.set(this.indexToValue(prev));
        }
        this.removeIndex(xIndex);
        this.prevIndex.set(next, prev);
        this.nextIndex.set(prev, next);
        return true;
    }

    @Override
    public int getSize() {
        return this.size.get();
    }

    @Override
    public int getNextValue(int x) {
        int inf = this.lowerBound.get();
        if (x < inf) {
            return inf;
        }
        if (!this.hasNextValue(x)) {
            return Integer.MAX_VALUE;
        }
        int xIndex = this.valueToIndex(x);
        if (this.nextIndex.get(xIndex) != -1) {
            return this.indexToValue(this.nextIndex.get(xIndex));
        }
        ++xIndex;
        while (this.nextIndex.get(xIndex) == -1) {
            ++xIndex;
        }
        return this.indexToValue(xIndex);
    }

    @Override
    public int getPrevValue(int x) {
        int sup = this.upperBound.get();
        if (x > sup) {
            return sup;
        }
        if (!this.hasPrevValue(x)) {
            return Integer.MIN_VALUE;
        }
        int xIndex = this.valueToIndex(x);
        if (this.prevIndex.get(xIndex) != -1) {
            return this.indexToValue(this.prevIndex.get(xIndex));
        }
        --xIndex;
        while (this.prevIndex.get(xIndex) == -1) {
            --xIndex;
        }
        return this.indexToValue(xIndex);
    }

    @Override
    public boolean hasNextValue(int x) {
        return x < this.upperBound.get();
    }

    @Override
    public boolean hasPrevValue(int x) {
        return x > this.lowerBound.get();
    }

    @Override
    public int getRandomValue() {
        int size = this.getSize();
        if (size == 1) {
            return this.getInf();
        }
        int rand = random.nextInt(size);
        int val = this.getInf();
        for (int o = 0; o < rand; ++o) {
            val = this.getNextValue(val);
        }
        return val;
    }

    @Override
    public boolean isEnumerated() {
        return true;
    }

    @Override
    public boolean isBoolean() {
        return this.offset == 0 && this.nextIndex.size() == 2;
    }

    @Override
    public DisposableIntIterator getDeltaIterator() {
        return new DeltaIntDomainIterator(this);
    }

    @Override
    public void freezeDeltaDomain() {
        super.freezeDeltaDomain();
        if (this.firstIndexBeingPropagated == -1) {
            this.firstIndexBeingPropagated = this.firstIndexToBePropagated;
            this.firstIndexToBePropagated = -1;
        }
    }

    @Override
    public boolean releaseDeltaDomain() {
        super.releaseDeltaDomain();
        if (this.firstIndexBeingPropagated == -1) {
            this.firstIndexToBePropagated = -1;
            return true;
        }
        this.firstIndexBeingPropagated = -1;
        return this.firstIndexToBePropagated == -1;
    }

    @Override
    public boolean getReleasedDeltaDomain() {
        return this.firstIndexBeingPropagated == -1 && this.firstIndexToBePropagated == -1;
    }

    @Override
    public void clearDeltaDomain() {
        this.firstIndexBeingPropagated = -1;
        this.firstIndexToBePropagated = -1;
    }

    public String toString() {
        return "{" + this.getInf() + "..." + this.getSup() + "}";
    }

    @Override
    public String pretty() {
        StringBuffer buf = new StringBuffer("{");
        int maxDisplay = 15;
        int count = 0;
        DisposableIntIterator it = this.getIterator();
        while (it.hasNext() && count < maxDisplay) {
            int val = it.next();
            if (++count > 1) {
                buf.append(", ");
            }
            buf.append(val);
        }
        if (this.getSize() > maxDisplay) {
            buf.append("..., ");
            buf.append(this.getSup());
        }
        buf.append("}");
        return buf.toString();
    }

    protected class DeltaIntDomainIterator
    extends DisposableIntIterator {
        protected LinkedIntDomain domain;
        protected int currentIndex = -1;

        private DeltaIntDomainIterator(LinkedIntDomain dom) {
            this.domain = dom;
            this.currentIndex = -1;
        }

        @Override
        public void dispose() {
        }

        @Override
        public boolean hasNext() {
            if (this.currentIndex == -1) {
                return LinkedIntDomain.this.firstIndexBeingPropagated != -1;
            }
            return LinkedIntDomain.this.chain[this.currentIndex] != -1;
        }

        @Override
        public int next() {
            this.currentIndex = this.currentIndex == -1 ? LinkedIntDomain.this.firstIndexBeingPropagated : LinkedIntDomain.this.chain[this.currentIndex];
            return this.currentIndex + LinkedIntDomain.this.offset;
        }

        @Override
        public void remove() {
            if (this.currentIndex == -1) {
                throw new IllegalStateException();
            }
            throw new UnsupportedOperationException();
        }
    }
}

