/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.variables.integer;

import choco.Choco;
import choco.cp.solver.variables.integer.AbstractIntDomain;
import choco.cp.solver.variables.integer.IntDomainVarImpl;
import choco.kernel.common.util.DisposableIntIterator;
import choco.kernel.memory.IEnvironment;
import choco.kernel.memory.IStateInt;
import choco.kernel.solver.ContradictionException;
import java.util.Random;

public class IntervalIntDomain
extends AbstractIntDomain {
    private static int eventBitMask = 7;
    protected static Random random = new Random(System.currentTimeMillis());
    protected final IStateInt inf;
    protected final IStateInt sup;
    protected int lastInfPropagated;
    protected int lastSupPropagated;

    public IntervalIntDomain(IntDomainVarImpl v, int a, int b) {
        this.variable = v;
        this.solver = v.getSolver();
        IEnvironment env = this.solver.getEnvironment();
        this.inf = env.makeInt(a);
        this.sup = env.makeInt(b);
        this.lastInfPropagated = a;
        this.lastSupPropagated = b;
        this.currentInfPropagated = Integer.MIN_VALUE;
        this.currentSupPropagated = Integer.MAX_VALUE;
    }

    @Override
    public boolean contains(int x) {
        return x >= this.getInf() && x <= this.getSup();
    }

    @Override
    public int getNextValue(int x) {
        if (x < this.getInf()) {
            return this.getInf();
        }
        if (x < this.getSup()) {
            return x + 1;
        }
        return Integer.MAX_VALUE;
    }

    @Override
    public int getPrevValue(int x) {
        if (x > this.getSup()) {
            return this.getSup();
        }
        if (x > this.getInf()) {
            return x - 1;
        }
        return Integer.MIN_VALUE;
    }

    @Override
    public int getRandomValue() {
        int inf = this.getInf();
        int rand = random.nextInt(this.getSize());
        return inf + rand;
    }

    @Override
    public int getSize() {
        return this.getSup() - this.getInf() + 1;
    }

    @Override
    public boolean hasNextValue(int x) {
        return x < this.getSup();
    }

    @Override
    public boolean hasPrevValue(int x) {
        return x > this.getInf();
    }

    @Override
    public DisposableIntIterator getIterator() {
        if (this.getSize() == 1) {
            return DisposableIntIterator.getOneValueIterator(this.getInf());
        }
        return new DisposableIntIterator(){
            int x;
            {
                this.x = IntervalIntDomain.this.getInf() - 1;
            }

            @Override
            public boolean hasNext() {
                return this.x < IntervalIntDomain.this.getSup();
            }

            @Override
            public int next() {
                return ++this.x;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public boolean remove(int x) {
        return false;
    }

    @Override
    public int getSup() {
        return this.sup.get();
    }

    @Override
    public int getInf() {
        return this.inf.get();
    }

    @Override
    public void restrict(int x) {
        if ((this.variable.getEvent().getPropagatedEvents() & eventBitMask) != 0 && this.lastInfPropagated == Integer.MIN_VALUE) {
            this.lastInfPropagated = this.inf.get();
            this.lastSupPropagated = this.sup.get();
        }
        this.inf.set(x);
        this.sup.set(x);
    }

    @Override
    public int updateInf(int x) {
        if ((this.variable.getEvent().getPropagatedEvents() & eventBitMask) != 0 && this.lastInfPropagated == Integer.MIN_VALUE) {
            this.lastInfPropagated = this.inf.get();
            this.lastSupPropagated = this.sup.get();
        }
        this.inf.set(x);
        return x;
    }

    @Override
    public int updateSup(int x) {
        if ((this.variable.getEvent().getPropagatedEvents() & eventBitMask) != 0 && this.lastInfPropagated == Integer.MIN_VALUE) {
            this.lastInfPropagated = this.inf.get();
            this.lastSupPropagated = this.sup.get();
        }
        this.sup.set(x);
        return x;
    }

    @Override
    protected boolean _removeVal(int x, int idx) throws ContradictionException {
        int infv = this.getInf();
        int supv = this.getSup();
        if (x == infv) {
            this._updateInf(x + 1, idx);
            if (this.getInf() == supv) {
                this._instantiate(supv, idx);
            }
            return true;
        }
        if (x == supv) {
            this._updateSup(x - 1, idx);
            if (this.getSup() == infv) {
                this._instantiate(infv, idx);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean isEnumerated() {
        return false;
    }

    @Override
    public boolean isBoolean() {
        return false;
    }

    @Override
    public void freezeDeltaDomain() {
        if ((this.variable.getEvent().getPropagatedEvents() & eventBitMask) != 0) {
            this.currentInfPropagated = this.getInf();
            this.currentSupPropagated = this.getSup();
        }
    }

    @Override
    public boolean releaseDeltaDomain() {
        if ((this.variable.getEvent().getPropagatedEvents() & eventBitMask) != 0) {
            boolean noNewUpdate;
            boolean bl = noNewUpdate = this.getInf() == this.currentInfPropagated && this.getSup() == this.currentSupPropagated;
            if (noNewUpdate) {
                this.lastInfPropagated = Integer.MIN_VALUE;
                this.lastSupPropagated = Integer.MAX_VALUE;
            } else {
                this.lastInfPropagated = this.currentInfPropagated;
                this.lastSupPropagated = this.currentSupPropagated;
            }
            this.currentInfPropagated = Integer.MIN_VALUE;
            this.currentSupPropagated = Integer.MAX_VALUE;
            return noNewUpdate;
        }
        return true;
    }

    @Override
    public void clearDeltaDomain() {
        if ((this.variable.getEvent().getPropagatedEvents() & eventBitMask) != 0) {
            this.lastInfPropagated = Integer.MIN_VALUE;
            this.lastSupPropagated = Integer.MAX_VALUE;
            this.currentInfPropagated = Integer.MIN_VALUE;
            this.currentSupPropagated = Integer.MAX_VALUE;
        }
    }

    @Override
    public boolean getReleasedDeltaDomain() {
        if ((this.variable.getEvent().getPropagatedEvents() & eventBitMask) != 0) {
            return this.currentInfPropagated == Integer.MIN_VALUE && this.currentSupPropagated == Integer.MAX_VALUE;
        }
        return true;
    }

    @Override
    public DisposableIntIterator getDeltaIterator() {
        if ((this.variable.getEvent().getPropagatedEvents() & eventBitMask) != 0) {
            return new DisposableIntIterator(){
                int x;
                {
                    this.x = IntervalIntDomain.this.lastInfPropagated - 1;
                }

                @Override
                public boolean hasNext() {
                    if (this.x + 1 == IntervalIntDomain.this.currentInfPropagated) {
                        return IntervalIntDomain.this.currentSupPropagated < IntervalIntDomain.this.lastSupPropagated;
                    }
                    if (this.x > IntervalIntDomain.this.currentSupPropagated) {
                        return this.x < IntervalIntDomain.this.lastSupPropagated;
                    }
                    return this.x + 1 < IntervalIntDomain.this.currentInfPropagated;
                }

                @Override
                public int next() {
                    ++this.x;
                    if (this.x == IntervalIntDomain.this.currentInfPropagated) {
                        this.x = IntervalIntDomain.this.currentSupPropagated + 1;
                    }
                    return this.x;
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }

                @Override
                public void dispose() {
                }
            };
        }
        return new DisposableIntIterator(){

            @Override
            public void dispose() {
            }

            @Override
            public boolean hasNext() {
                return false;
            }

            @Override
            public int next() {
                return 42;
            }

            @Override
            public void remove() {
            }
        };
    }

    @Override
    public String pretty() {
        String ret = "[" + this.getInf() + " .. " + this.getSup() + "]";
        if (Choco.DEBUG) {
            ret = ret + this.lastInfPropagated + "->" + this.lastSupPropagated;
        }
        return ret;
    }
}

