/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.variables.integer;

import choco.cp.solver.variables.integer.AbstractIntDomain;
import choco.cp.solver.variables.integer.IntDomainVarImpl;
import choco.kernel.common.util.DisposableIntIterator;
import choco.kernel.memory.IEnvironment;
import choco.kernel.memory.IStateBinaryTree;
import choco.kernel.memory.IStateInt;
import gnu.trove.TIntStack;
import java.util.ArrayList;
import java.util.Random;

public class IntervalBTreeDomain
extends AbstractIntDomain {
    protected static Random random = new Random(System.currentTimeMillis());
    public IStateBinaryTree btree;
    IStateInt size;
    protected int capacity;
    protected TIntStack stack;
    protected int lastSizeBeforePropagation;
    protected DisposableIntIterator _cachedDeltaIntDomainIterator = null;

    public IntervalBTreeDomain(IntDomainVarImpl v, int a, int b) {
        this.variable = v;
        this.solver = v.getSolver();
        IEnvironment env = this.solver.getEnvironment();
        this.btree = env.makeBinaryTree(a, b);
        this.capacity = b - a + 1;
        this.size = env.makeInt(this.capacity);
        this.stack = new TIntStack();
        this.lastSizeBeforePropagation = 0;
    }

    public IntervalBTreeDomain(IntDomainVarImpl v, int[] sortedValues) {
        this.variable = v;
        this.solver = v.getSolver();
        IEnvironment env = this.solver.getEnvironment();
        int a = sortedValues[0];
        this.btree = env.makeBinaryTree(a, a);
        this.capacity = sortedValues.length;
        IStateBinaryTree.Node n = this.btree.getRoot();
        for (int i = 1; i < this.capacity; ++i) {
            int b = sortedValues[i];
            if (b == a + 1) {
                n.setSup(b);
            } else {
                n = new IStateBinaryTree.Node(this.btree, b, b);
                this.btree.add(n, false);
            }
            a = b;
        }
        this.size = env.makeInt(this.btree.getSize());
        this.stack = new TIntStack();
        this.lastSizeBeforePropagation = 0;
    }

    @Override
    public int getInf() {
        IStateBinaryTree.Node n = this.btree.getFirstNode();
        return n.inf;
    }

    @Override
    public int getSup() {
        IStateBinaryTree.Node n = this.btree.getLastNode();
        return n.sup;
    }

    @Override
    public int updateInf(int x) {
        for (int i = this.getInf(); i < x; ++i) {
            this.remove(i);
        }
        return this.getInf();
    }

    @Override
    public int updateSup(int x) {
        for (int i = this.getSup(); i > x; --i) {
            this.remove(i);
        }
        return this.getSup();
    }

    @Override
    public boolean contains(int x) {
        return this.btree.find(x) != null;
    }

    @Override
    public boolean remove(int x) {
        boolean b = this.btree.remove(x);
        if (b) {
            this.removeIndex(x);
            this.size.add(-1);
        }
        return b;
    }

    private void removeIndex(int i) {
        this.stack.push(i);
    }

    @Override
    public void restrict(int x) {
        IStateBinaryTree.Node current = this.btree.getRoot();
        while (current.leftNode != null) {
            this.btree.remove(current.leftNode);
        }
        while (current.rightNode != null) {
            this.btree.remove(current.rightNode);
        }
        this.btree.getRoot().setInf(x);
        this.btree.getRoot().setSup(x);
        this.size.set(1);
    }

    @Override
    public int getSize() {
        return this.size.get();
    }

    @Override
    public int getNextValue(int x) {
        IStateBinaryTree.Node n = this.btree.nextNode(x);
        if (n == null) {
            return Integer.MAX_VALUE;
        }
        if (n.contains(x + 1)) {
            return x + 1;
        }
        return n.getInf();
    }

    @Override
    public int getPrevValue(int x) {
        IStateBinaryTree.Node n = this.btree.prevNode(x);
        if (n == null) {
            return Integer.MIN_VALUE;
        }
        if (n.contains(x - 1)) {
            return x - 1;
        }
        return n.getInf();
    }

    @Override
    public boolean hasNextValue(int x) {
        return x < this.getSup();
    }

    @Override
    public boolean hasPrevValue(int x) {
        return x > this.getInf();
    }

    @Override
    public int getRandomValue() {
        ArrayList<IStateBinaryTree.Node> tmp = new ArrayList<IStateBinaryTree.Node>();
        IStateBinaryTree.Node current = this.btree.getRoot();
        while (current != null) {
            tmp.add(current);
            if (random.nextBoolean()) {
                current = current.leftNode;
                continue;
            }
            current = current.rightNode;
        }
        IStateBinaryTree.Node selected = (IStateBinaryTree.Node)tmp.get(random.nextInt(tmp.size()));
        int val = random.nextInt(selected.sup - selected.inf + 1);
        return val + selected.inf;
    }

    @Override
    public DisposableIntIterator getDeltaIterator() {
        DeltaIntDomainIterator iter = (DeltaIntDomainIterator)this._cachedDeltaIntDomainIterator;
        if (iter != null && iter.reusable) {
            iter.init();
            return iter;
        }
        this._cachedDeltaIntDomainIterator = new DeltaIntDomainIterator(this);
        return this._cachedDeltaIntDomainIterator;
    }

    @Override
    public void freezeDeltaDomain() {
        if (this.lastSizeBeforePropagation == 0) {
            this.lastSizeBeforePropagation = this.stack.size();
        }
    }

    @Override
    public boolean releaseDeltaDomain() {
        if (this.lastSizeBeforePropagation == this.stack.size()) {
            this.stack.clear();
            this.lastSizeBeforePropagation = 0;
            return true;
        }
        this.lastSizeBeforePropagation = 0;
        return this.stack.size() == 0;
    }

    @Override
    public boolean getReleasedDeltaDomain() {
        return this.stack.size() == 0 && this.lastSizeBeforePropagation == 0;
    }

    @Override
    public void clearDeltaDomain() {
        this.lastSizeBeforePropagation = 0;
        this.stack.clear();
    }

    @Override
    public boolean isEnumerated() {
        return true;
    }

    @Override
    public boolean isBoolean() {
        return false;
    }

    @Override
    public String pretty() {
        return ((Object)this.btree).toString();
    }

    public String toString() {
        return ((Object)this.btree).toString();
    }

    protected class DeltaIntDomainIterator
    extends DisposableIntIterator {
        protected IntervalBTreeDomain domain;
        protected int currentVal;

        private DeltaIntDomainIterator(IntervalBTreeDomain dom) {
            this.domain = dom;
            this.init();
        }

        @Override
        public void init() {
            super.init();
        }

        @Override
        public boolean hasNext() {
            if (IntervalBTreeDomain.this.stack.size() > 0) {
                this.currentVal = IntervalBTreeDomain.this.stack.pop();
                return true;
            }
            return false;
        }

        @Override
        public int next() {
            return this.currentVal;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

