/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.variables.integer;

import choco.cp.solver.variables.integer.IntDomainVarImpl;
import choco.kernel.common.util.DisposableIntIterator;
import choco.kernel.common.util.IntIterator;
import choco.kernel.memory.PartiallyStoredIntVector;
import choco.kernel.memory.PartiallyStoredVector;
import choco.kernel.solver.ContradictionException;
import choco.kernel.solver.constraints.SConstraint;
import choco.kernel.solver.constraints.integer.IntSConstraint;
import choco.kernel.solver.propagation.VarEvent;
import java.util.logging.Level;

public class IntVarEvent
extends VarEvent<IntDomainVarImpl> {
    public static final int INCINF = 0;
    public static final int DECSUP = 1;
    public static final int REMVAL = 2;
    public static final int INSTINT = 3;
    public static final int INCINFbitvector = 1;
    public static final int DECSUPbitvector = 2;
    public static final int BOUNDSbitvector = 3;
    public static final int REMVALbitvector = 4;
    public static final int INSTINTbitvector = 8;

    public IntVarEvent(IntDomainVarImpl var) {
        super(var);
        this.eventType = 0;
    }

    public String toString() {
        return "VarEvt(" + this.modifiedVar + ")[" + this.eventType + ":" + ((this.eventType & 1) != 0 ? "I" : "") + ((this.eventType & 2) != 0 ? "S" : "") + ((this.eventType & 4) != 0 ? "r" : "") + ((this.eventType & 8) != 0 ? "X" : "") + "]";
    }

    @Override
    public int getEventType() {
        return this.eventType;
    }

    @Override
    public int getPriority() {
        return ((IntDomainVarImpl)this.modifiedVar).getPriority();
    }

    @Override
    public void clear() {
        this.eventType = 0;
        this.cause = -2;
        ((IntDomainVarImpl)this.modifiedVar).getDomain().clearDeltaDomain();
    }

    @Override
    protected boolean release() {
        return ((IntDomainVarImpl)this.modifiedVar).getDomain().releaseDeltaDomain();
    }

    @Override
    protected void freeze() {
        ((IntDomainVarImpl)this.modifiedVar).getDomain().freezeDeltaDomain();
        this.cause = -2;
        this.eventType = 0;
    }

    public boolean getReleased() {
        return ((IntDomainVarImpl)this.modifiedVar).getDomain().getReleasedDeltaDomain();
    }

    public DisposableIntIterator getEventIterator() {
        return ((IntDomainVarImpl)this.modifiedVar).getDomain().getDeltaIterator();
    }

    @Override
    public boolean propagateEvent() throws ContradictionException {
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("propagate " + this.toString());
        }
        int evtType = this.eventType;
        int evtCause = this.cause;
        this.freeze();
        if ((this.propagatedEvents & 8) != 0 && (evtType & 8) != 0) {
            this.propagateInstEvent(evtCause);
        }
        if ((this.propagatedEvents & 1) != 0 && (evtType & 1) != 0) {
            this.propagateInfEvent(evtCause);
        }
        if ((this.propagatedEvents & 2) != 0 && (evtType & 2) != 0) {
            this.propagateSupEvent(evtCause);
        }
        if ((this.propagatedEvents & 4) != 0 && (evtType & 4) != 0) {
            this.propagateRemovalsEvent(evtCause);
        }
        return this.release();
    }

    public void propagateInstEvent(int evtCause) throws ContradictionException {
        IntDomainVarImpl v = (IntDomainVarImpl)this.modifiedVar;
        PartiallyStoredVector<SConstraint> constraints = v.getConstraintVector();
        PartiallyStoredIntVector indices = v.getIndexVector();
        PartiallyStoredIntVector cindices = v.getEventsVector()[0];
        IntIterator cit = cindices.getIndexIterator();
        while (cit.hasNext()) {
            int idx = cindices.get(cit.next());
            if (idx == evtCause) continue;
            IntSConstraint c = (IntSConstraint)constraints.get(idx);
            int i = indices.get(idx);
            if (!c.isActive()) continue;
            c.awakeOnInst(i);
        }
    }

    public void propagateInfEvent(int evtCause) throws ContradictionException {
        IntDomainVarImpl v = (IntDomainVarImpl)this.modifiedVar;
        PartiallyStoredVector<SConstraint> constraints = v.getConstraintVector();
        PartiallyStoredIntVector indices = v.getIndexVector();
        PartiallyStoredIntVector cindices = v.getEventsVector()[1];
        IntIterator cit = cindices.getIndexIterator();
        while (cit.hasNext()) {
            int idx = cindices.get(cit.next());
            if (idx == evtCause) continue;
            IntSConstraint c = (IntSConstraint)constraints.get(idx);
            int i = indices.get(idx);
            if (!c.isActive()) continue;
            c.awakeOnInf(i);
        }
    }

    public void propagateSupEvent(int evtCause) throws ContradictionException {
        IntDomainVarImpl v = (IntDomainVarImpl)this.modifiedVar;
        PartiallyStoredVector<SConstraint> constraints = v.getConstraintVector();
        PartiallyStoredIntVector indices = v.getIndexVector();
        PartiallyStoredIntVector cindices = v.getEventsVector()[2];
        IntIterator cit = cindices.getIndexIterator();
        while (cit.hasNext()) {
            int idx = cindices.get(cit.next());
            if (idx == evtCause) continue;
            IntSConstraint c = (IntSConstraint)constraints.get(idx);
            int i = indices.get(idx);
            if (!c.isActive()) continue;
            c.awakeOnSup(i);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void propagateRemovalsEvent(int evtCause) throws ContradictionException {
        IntDomainVarImpl v = (IntDomainVarImpl)this.modifiedVar;
        PartiallyStoredVector<SConstraint> constraints = v.getConstraintVector();
        PartiallyStoredIntVector indices = v.getIndexVector();
        PartiallyStoredIntVector cindices = v.getEventsVector()[3];
        IntIterator cit = cindices.getIndexIterator();
        while (cit.hasNext()) {
            int idx = cindices.get(cit.next());
            if (idx == evtCause) continue;
            IntSConstraint c = (IntSConstraint)constraints.get(idx);
            int i = indices.get(idx);
            if (!c.isActive()) continue;
            DisposableIntIterator iter = this.getEventIterator();
            try {
                c.awakeOnRemovals(i, iter);
            }
            finally {
                iter.dispose();
            }
        }
    }

    private int promoteEvent(int basicEvt) {
        switch (basicEvt) {
            case 3: {
                return 15;
            }
            case 0: {
                return 5;
            }
            case 1: {
                return 6;
            }
            case 2: {
                return 4;
            }
        }
        return 1 << basicEvt;
    }

    @Override
    public void recordEventTypeAndCause(int basicEvt, int idx) {
        if (this.cause == -2 || this.eventType == 0) {
            this.eventType = this.promoteEvent(basicEvt);
            this.cause = idx;
        } else {
            this.eventType |= this.promoteEvent(basicEvt);
            if (this.cause != idx) {
                this.cause = -1;
            }
        }
    }
}

