/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.variables.integer;

import choco.kernel.solver.constraints.integer.IntExp;
import choco.kernel.solver.variables.integer.IntVar;

public class IntTerm
implements IntExp {
    protected final int[] coefficients;
    protected final IntVar[] variables;
    protected int nbVars;
    protected int constant;

    public IntTerm(int capacity) {
        this.coefficients = new int[capacity];
        this.variables = new IntVar[capacity];
        this.nbVars = capacity;
        this.constant = 0;
    }

    public IntTerm(IntTerm t1) {
        int capacity = t1.getSize();
        this.coefficients = new int[capacity];
        this.variables = new IntVar[capacity];
        this.nbVars = capacity;
        for (int i = 0; i < capacity; ++i) {
            this.coefficients[i] = t1.getCoefficient(i);
            this.variables[i] = t1.getVariable(i);
        }
        this.constant = t1.constant;
    }

    public String pretty() {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < this.coefficients.length; ++i) {
            int coefficient = this.coefficients[i];
            IntVar variable = this.variables[i];
            if (i > 0) {
                buf.append(" + ");
            }
            buf.append(coefficient + "*" + variable);
        }
        buf.append(" + " + this.constant);
        return buf.toString();
    }

    public int[] getCoefficients() {
        return this.coefficients;
    }

    public IntVar[] getVariables() {
        return this.variables;
    }

    public int getCoefficient(int index) {
        return this.coefficients[index];
    }

    public IntVar getVariable(int index) {
        return this.variables[index];
    }

    public void setCoefficient(int index, int coef) {
        this.coefficients[index] = coef;
    }

    public void setVariable(int index, IntVar var) {
        this.variables[index] = var;
    }

    public int getSize() {
        return this.nbVars;
    }

    public int getConstant() {
        return this.constant;
    }

    public void setConstant(int constant) {
        this.constant = constant;
    }
}

