/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.variables.integer;

import choco.cp.solver.variables.integer.AbstractIntDomain;
import choco.cp.solver.variables.integer.BipartiteIntDomain;
import choco.cp.solver.variables.integer.BitSetIntDomain;
import choco.cp.solver.variables.integer.BooleanDomain;
import choco.cp.solver.variables.integer.IntVarEvent;
import choco.cp.solver.variables.integer.IntervalBTreeDomain;
import choco.cp.solver.variables.integer.IntervalIntDomain;
import choco.cp.solver.variables.integer.LinkedIntDomain;
import choco.kernel.common.util.DisposableIntIterator;
import choco.kernel.memory.IEnvironment;
import choco.kernel.memory.IStateInt;
import choco.kernel.memory.PartiallyStoredIntVector;
import choco.kernel.solver.ContradictionException;
import choco.kernel.solver.Solver;
import choco.kernel.solver.constraints.SConstraint;
import choco.kernel.solver.propagation.Propagator;
import choco.kernel.solver.variables.AbstractVar;
import choco.kernel.solver.variables.integer.IntDomain;
import choco.kernel.solver.variables.integer.IntDomainVar;
import java.util.logging.Level;
import java.util.logging.Logger;

public class IntDomainVarImpl
extends AbstractVar
implements IntDomainVar {
    protected AbstractIntDomain domain;
    protected static Logger logger = Logger.getLogger("choco.kernel.solver.propagation");
    protected PartiallyStoredIntVector[] events;
    protected IStateInt priority;

    public IntDomainVarImpl(Solver solver, String name) {
        super(solver, name);
        this.buildDataStructures(solver.getEnvironment());
    }

    public IntDomainVarImpl(Solver solver, String name, int domainType, int a, int b) {
        super(solver, name);
        this.domain = domainType == 0 ? new BitSetIntDomain(this, a, b) : (domainType == 2 ? new LinkedIntDomain(this, a, b) : (domainType == 3 ? new IntervalBTreeDomain(this, a, b) : (domainType == 4 ? new BipartiteIntDomain(this, a, b) : (domainType == 5 ? new BooleanDomain(this) : new IntervalIntDomain(this, a, b)))));
        this.event = new IntVarEvent(this);
        this.buildDataStructures(solver.getEnvironment());
    }

    public IntDomainVarImpl(Solver solver, String name, int domainType, int[] sortedValues) {
        super(solver, name);
        this.domain = domainType == 3 ? new IntervalBTreeDomain(this, sortedValues) : (domainType == 2 ? new LinkedIntDomain(this, sortedValues) : (domainType == 4 ? new BipartiteIntDomain(this, sortedValues) : new BitSetIntDomain(this, sortedValues)));
        this.event = new IntVarEvent(this);
        this.buildDataStructures(solver.getEnvironment());
    }

    protected void buildDataStructures(IEnvironment env) {
        this.events = new PartiallyStoredIntVector[4];
        for (int i = 0; i < 4; ++i) {
            this.events[i] = env.makePartiallyStoredIntVector();
        }
        this.priority = env.makeInt(0);
    }

    @Override
    public int addConstraint(SConstraint c, int varIdx, boolean dynamicAddition) {
        int constraintIdx = super.addConstraint(c, varIdx, dynamicAddition);
        this.computePriority(c);
        int mask = ((Propagator)c).getFilteredEventMask(varIdx);
        if ((mask & 8) != 0) {
            this.addEvent(dynamicAddition, 0, constraintIdx);
        }
        if ((mask & 1) != 0) {
            this.addEvent(dynamicAddition, 1, constraintIdx);
        }
        if ((mask & 2) != 0) {
            this.addEvent(dynamicAddition, 2, constraintIdx);
        }
        if ((mask & 4) != 0) {
            this.addEvent(dynamicAddition, 3, constraintIdx);
        }
        return constraintIdx;
    }

    private void addEvent(boolean dynamicAddition, int indice, int constraintIdx) {
        if (dynamicAddition) {
            this.events[indice].add(constraintIdx);
        } else {
            this.events[indice].staticAdd(constraintIdx);
        }
    }

    private void computePriority(SConstraint c) {
        this.priority.set(Math.max(this.priority.get(), ((Propagator)c).getPriority()));
    }

    @Override
    public void eraseConstraint(SConstraint c) {
        int constraintIdx = this.constraints.remove(c);
        this.indices.remove(constraintIdx);
        int mask = ((Propagator)c).getFilteredEventMask(this.indices.get(constraintIdx));
        if ((mask & 8) != 0) {
            this.events[0].remove(constraintIdx);
        }
        if ((mask & 1) != 0) {
            this.events[1].remove(constraintIdx);
        }
        if ((mask & 2) != 0) {
            this.events[2].remove(constraintIdx);
        }
        if ((mask & 4) != 0) {
            this.events[3].remove(constraintIdx);
        }
    }

    public PartiallyStoredIntVector[] getEventsVector() {
        return this.events;
    }

    public int getPriority() {
        return this.priority.get();
    }

    @Override
    public boolean isInstantiatedTo(int x) {
        return this.isInstantiated() && this.getVal() == x;
    }

    @Override
    public boolean isInstantiated() {
        return this.domain.getSize() == 1;
    }

    @Override
    public boolean canBeInstantiatedTo(int x) {
        return this.getInf() <= x && x <= this.getSup() && (this.domain == null || this.domain.contains(x));
    }

    @Override
    public boolean fastCanBeInstantiatedTo(int x) {
        return this.domain.contains(x);
    }

    @Override
    public void setInf(int x) throws ContradictionException {
        this.updateInf(x, -1);
    }

    @Override
    public void setMin(int x) throws ContradictionException {
        this.updateInf(x, -1);
    }

    @Override
    public void setSup(int x) throws ContradictionException {
        this.updateSup(x, -1);
    }

    @Override
    public void setMax(int x) throws ContradictionException {
        this.updateSup(x, -1);
    }

    @Override
    public void setVal(int x) throws ContradictionException {
        this.instantiate(x, -1);
    }

    @Override
    public void remVal(int x) throws ContradictionException {
        this.removeVal(x, -1);
    }

    @Override
    public void wipeOut() throws ContradictionException {
        this.getSolver().getPropagationEngine().raiseContradiction(this, 3);
    }

    @Override
    public boolean hasEnumeratedDomain() {
        return this.domain.isEnumerated();
    }

    @Override
    public boolean hasBooleanDomain() {
        return this.domain.isBoolean();
    }

    @Override
    public IntDomain getDomain() {
        return this.domain;
    }

    @Override
    public int getDomainSize() {
        return this.domain.getSize();
    }

    @Override
    public boolean canBeEqualTo(IntDomainVar x) {
        if (x.getInf() <= this.getSup()) {
            if (this.getInf() <= x.getSup()) {
                if (!this.hasEnumeratedDomain() || !x.hasEnumeratedDomain()) {
                    return true;
                }
                DisposableIntIterator it = this.getDomain().getIterator();
                while (it.hasNext()) {
                    int v = it.next();
                    if (!x.canBeInstantiatedTo(v)) continue;
                    return true;
                }
                return false;
            }
            return false;
        }
        return false;
    }

    @Override
    public boolean canBeInstantiatedIn(int[] sortedValList, int nVals) {
        if (this.getInf() <= sortedValList[nVals - 1]) {
            if (this.getSup() >= sortedValList[0]) {
                if (this.domain == null) {
                    return true;
                }
                for (int i = 0; i < nVals; ++i) {
                    if (!this.canBeInstantiatedTo(sortedValList[i])) continue;
                    return true;
                }
                return false;
            }
            return false;
        }
        return false;
    }

    @Override
    public int getRandomDomainValue() {
        if (this.domain == null) {
            return this.getInf();
        }
        return this.domain.getRandomValue();
    }

    @Override
    public int getNextDomainValue(int currentv) {
        if (currentv < this.getInf()) {
            return this.getInf();
        }
        if (this.domain == null) {
            return currentv + 1;
        }
        return this.domain.getNextValue(currentv);
    }

    @Override
    public int getPrevDomainValue(int currentv) {
        if (currentv > this.getSup()) {
            return this.getSup();
        }
        if (this.domain == null) {
            return currentv - 1;
        }
        return this.domain.getPrevValue(currentv);
    }

    @Override
    public boolean updateInf(int x, int idx) throws ContradictionException {
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("INF(" + this.toString() + "): " + this.getInf() + " -> " + x);
        }
        return this.domain.updateInf(x, idx);
    }

    @Override
    public boolean updateSup(int x, int idx) throws ContradictionException {
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("SUP(" + this.toString() + "): " + this.getSup() + " -> " + x);
        }
        return this.domain.updateSup(x, idx);
    }

    @Override
    public boolean removeVal(int x, int idx) throws ContradictionException {
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("REM(" + this.toString() + "): - " + x);
        }
        return this.domain.removeVal(x, idx);
    }

    @Override
    public boolean removeInterval(int a, int b, int idx) throws ContradictionException {
        return this.domain.removeInterval(a, b, idx);
    }

    @Override
    public boolean instantiate(int x, int idx) throws ContradictionException {
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("INST(" + this.toString() + "):-> " + x);
        }
        return this.domain.instantiate(x, idx);
    }

    @Override
    public void fail() throws ContradictionException {
        this.solver.getPropagationEngine().raiseContradiction(this, 3);
    }

    @Override
    public int getInf() {
        return this.domain.getInf();
    }

    @Override
    public int getSup() {
        return this.domain.getSup();
    }

    @Override
    public int getVal() {
        return this.domain.getInf();
    }

    @Override
    public int getValue() {
        return this.domain.getInf();
    }

    @Override
    public String toString() {
        return super.toString() + ":" + (this.isInstantiated() ? Integer.valueOf(this.getVal()) : "?");
    }

    @Override
    public String pretty() {
        return this.toString() + "[" + this.domain.getSize() + "]" + this.domain.pretty();
    }

    @Override
    public Solver getSolver() {
        return this.solver;
    }

    @Override
    public void setSolver(Solver solver) {
        this.solver = solver;
    }
}

