/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.variables.integer;

import choco.cp.solver.variables.integer.BoolVarEvent;
import choco.cp.solver.variables.integer.BooleanDomain;
import choco.cp.solver.variables.integer.IntDomainVarImpl;
import choco.kernel.solver.ContradictionException;
import choco.kernel.solver.Solver;
import choco.kernel.solver.variables.integer.IntDomain;
import choco.kernel.solver.variables.integer.IntDomainVar;
import java.util.logging.Level;

public class BooleanVarImpl
extends IntDomainVarImpl {
    protected BooleanDomain booldomain = new BooleanDomain(this);

    public BooleanVarImpl(Solver solver, String name) {
        super(solver, name);
        this.event = new BoolVarEvent(this);
    }

    @Override
    public boolean isInstantiatedTo(int x) {
        if (this.booldomain.isInstantiated()) {
            return x == this.booldomain.getValueIfInst();
        }
        return false;
    }

    @Override
    public final boolean isInstantiated() {
        return this.booldomain.isInstantiated();
    }

    @Override
    public boolean canBeInstantiatedTo(int x) {
        if (this.booldomain.isInstantiated()) {
            return x == this.booldomain.getValueIfInst();
        }
        return x >= 0 && x <= 1;
    }

    @Override
    public boolean fastCanBeInstantiatedTo(int x) {
        if (this.booldomain.isInstantiated()) {
            return x == this.booldomain.getValueIfInst();
        }
        return true;
    }

    @Override
    public boolean hasEnumeratedDomain() {
        return true;
    }

    @Override
    public boolean hasBooleanDomain() {
        return true;
    }

    @Override
    public int getDomainSize() {
        return this.booldomain.getSize();
    }

    @Override
    public boolean canBeEqualTo(IntDomainVar x) {
        if (this.booldomain.isInstantiated()) {
            return x.canBeInstantiatedTo(this.booldomain.getValueIfInst());
        }
        return x.fastCanBeInstantiatedTo(0) || x.fastCanBeInstantiatedTo(1);
    }

    @Override
    public IntDomain getDomain() {
        return this.booldomain;
    }

    @Override
    public boolean canBeInstantiatedIn(int[] sortedValList, int nVals) {
        if (this.getInf() <= sortedValList[nVals - 1] && this.getSup() >= sortedValList[0]) {
            if (this.booldomain.isInstantiated()) {
                int val = this.booldomain.getValueIfInst();
                for (int i = 0; i < nVals; ++i) {
                    if (sortedValList[i] != val) continue;
                    return true;
                }
            } else {
                for (int i = 0; i < nVals; ++i) {
                    if (sortedValList[i] != 0 && sortedValList[i] != 1) continue;
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    @Override
    public int getRandomDomainValue() {
        return this.booldomain.getRandomValue();
    }

    @Override
    public int getNextDomainValue(int currentv) {
        return this.booldomain.getNextValue(currentv);
    }

    @Override
    public int getPrevDomainValue(int currentv) {
        return this.booldomain.getPrevValue(currentv);
    }

    @Override
    public boolean updateInf(int x, int idx) throws ContradictionException {
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("INF(" + this.toString() + "): " + this.getInf() + " -> " + x);
        }
        if (x > 0) {
            return this.booldomain.instantiate(x, idx);
        }
        return false;
    }

    @Override
    public boolean updateSup(int x, int idx) throws ContradictionException {
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("SUP(" + this.toString() + "): " + this.getSup() + " -> " + x);
        }
        if (x < 1) {
            return this.booldomain.instantiate(x, idx);
        }
        return false;
    }

    @Override
    public boolean removeVal(int x, int idx) throws ContradictionException {
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("REM(" + this.toString() + "): - " + x);
        }
        if (x == 0) {
            return this.booldomain.instantiate(1, idx);
        }
        if (x == 1) {
            return this.booldomain.instantiate(0, idx);
        }
        return false;
    }

    @Override
    public boolean removeInterval(int a, int b, int idx) throws ContradictionException {
        return this.booldomain.removeInterval(a, b, idx);
    }

    @Override
    public boolean instantiate(int x, int idx) throws ContradictionException {
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("INST(" + this.toString() + "):-> " + x);
        }
        return this.booldomain.instantiate(x, idx);
    }

    @Override
    public int getInf() {
        if (this.booldomain.isInstantiated()) {
            return this.booldomain.getValueIfInst();
        }
        return 0;
    }

    @Override
    public int getSup() {
        if (this.booldomain.isInstantiated()) {
            return this.booldomain.getValueIfInst();
        }
        return 1;
    }

    @Override
    public int getVal() {
        return this.booldomain.getValueIfInst();
    }

    @Override
    public int getValue() {
        return this.booldomain.getValueIfInst();
    }

    @Override
    public String toString() {
        return this.name + ":" + (this.isInstantiated() ? Integer.valueOf(this.getVal()) : "?");
    }

    @Override
    public String pretty() {
        return this.toString() + "[" + this.booldomain.getSize() + "]" + this.booldomain.pretty();
    }
}

