/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.variables.integer;

import choco.cp.solver.variables.integer.AbstractIntDomain;
import choco.cp.solver.variables.integer.IntDomainVarImpl;
import choco.kernel.common.util.DisposableIntIterator;
import choco.kernel.memory.IEnvironment;
import choco.kernel.memory.trailing.StoredIndexedBipartiteSet;
import choco.kernel.solver.ContradictionException;
import choco.kernel.solver.SolverException;
import java.util.Random;
import java.util.logging.Level;

public class BooleanDomain
extends AbstractIntDomain {
    protected static Random random = new Random(System.currentTimeMillis());
    protected final int offset;
    protected int value;
    protected StoredIndexedBipartiteSet notInstanciated;
    protected DisposableIntIterator _cachedDeltaIntDomainIterator = null;

    public BooleanDomain(IntDomainVarImpl v) {
        this.variable = v;
        this.solver = v.getSolver();
        IEnvironment env = this.solver.getEnvironment();
        this.notInstanciated = (StoredIndexedBipartiteSet)env.getSharedBipartiteSetForBooleanVars();
        this.offset = env.getNextOffset();
        this.value = 0;
    }

    public int getValueIfInst() {
        return this.value;
    }

    public boolean isInstantiated() {
        return !this.notInstanciated.contain(this.offset);
    }

    @Override
    public int getInf() {
        if (!this.notInstanciated.contain(this.offset)) {
            return this.getValueIfInst();
        }
        return 0;
    }

    @Override
    public int getSup() {
        if (!this.notInstanciated.contain(this.offset)) {
            return this.getValueIfInst();
        }
        return 1;
    }

    @Override
    public int updateInf(int x) {
        throw new SolverException("Unexpected call of updateInf");
    }

    @Override
    public int updateSup(int x) {
        throw new SolverException("Unexpected call of updateSup");
    }

    @Override
    public final boolean contains(int x) {
        if (!this.notInstanciated.contain(this.offset)) {
            return this.getValueIfInst() == x;
        }
        return x == 0 || x == 1;
    }

    @Override
    public boolean remove(int x) {
        throw new SolverException("Unexpected call of remove");
    }

    @Override
    public void restrict(int x) {
        this.notInstanciated.remove(this.offset);
        this.value = x;
    }

    @Override
    public int getSize() {
        return this.notInstanciated.contain(this.offset) ? 2 : 1;
    }

    @Override
    public DisposableIntIterator getIterator() {
        if (this.getSize() == 1) {
            return DisposableIntIterator.getOneValueIterator(this.getInf());
        }
        BitSetIntDomainIterator iter = (BitSetIntDomainIterator)this.lastIterator;
        if (iter != null && iter.reusable) {
            iter.init();
            return iter;
        }
        this.lastIterator = new BitSetIntDomainIterator();
        return this.lastIterator;
    }

    @Override
    public final int getNextValue(int x) {
        if (!this.notInstanciated.contain(this.offset)) {
            int val = this.getValueIfInst();
            return val > x ? val : Integer.MAX_VALUE;
        }
        if (x < 0) {
            return 0;
        }
        if (x == 0) {
            return 1;
        }
        return Integer.MAX_VALUE;
    }

    @Override
    public int getPrevValue(int x) {
        if (x > this.getSup()) {
            return this.getSup();
        }
        if (x > this.getInf()) {
            return this.getInf();
        }
        return Integer.MIN_VALUE;
    }

    @Override
    public boolean hasNextValue(int x) {
        return x < this.getSup();
    }

    @Override
    public boolean hasPrevValue(int x) {
        return x > this.getInf();
    }

    @Override
    public int getRandomValue() {
        if (!this.notInstanciated.contain(this.offset)) {
            return this.getValueIfInst();
        }
        return random.nextInt(2);
    }

    @Override
    public boolean isEnumerated() {
        return true;
    }

    @Override
    public boolean isBoolean() {
        return true;
    }

    @Override
    public DisposableIntIterator getDeltaIterator() {
        DeltaBoolDomainIterator iter = (DeltaBoolDomainIterator)this._cachedDeltaIntDomainIterator;
        if (iter != null && iter.disposed) {
            iter.init();
            return iter;
        }
        this._cachedDeltaIntDomainIterator = new DeltaBoolDomainIterator(this);
        return this._cachedDeltaIntDomainIterator;
    }

    public String toString() {
        return "[" + this.getInf() + "," + this.getSup() + "]";
    }

    @Override
    public String pretty() {
        return this.toString();
    }

    @Override
    public boolean updateSup(int x, int idx) throws ContradictionException {
        if (this._updateSup(x, idx)) {
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest("INST(" + this.toString() + "): " + x);
            }
            this.solver.getPropagationEngine().postInstInt(this.variable, idx);
            return true;
        }
        return false;
    }

    @Override
    public boolean updateInf(int x, int idx) throws ContradictionException {
        if (this._updateInf(x, idx)) {
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest("INST(" + this.toString() + "): " + x);
            }
            this.solver.getPropagationEngine().postInstInt(this.variable, idx);
            return true;
        }
        return false;
    }

    @Override
    public boolean removeVal(int x, int idx) throws ContradictionException {
        if (this._removeVal(x, idx)) {
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest("INST(" + this.toString() + "): " + x);
            }
            this.solver.getPropagationEngine().postInstInt(this.variable, idx);
            return true;
        }
        return false;
    }

    @Override
    public boolean instantiate(int x, int idx) throws ContradictionException {
        if (this._instantiate(x, idx)) {
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest("INST(" + this.toString() + "): " + x);
            }
            this.solver.getPropagationEngine().postInstInt(this.variable, idx);
            return true;
        }
        return false;
    }

    public void failOnIndex(int idx) throws ContradictionException {
        if (idx == -1) {
            this.getSolver().getPropagationEngine().raiseContradiction(this.variable, 1);
        } else {
            this.getSolver().getPropagationEngine().raiseContradiction(this.variable.getConstraintVector().get(idx), 2);
        }
    }

    @Override
    protected boolean _instantiate(int x, int idx) throws ContradictionException {
        if (!this.notInstanciated.contain(this.offset)) {
            if (this.value != x) {
                this.failOnIndex(idx);
            }
            return false;
        }
        if (x == 0 || x == 1) {
            this.restrict(x);
            this.variable.updateNbVarInstanciated();
            return true;
        }
        this.failOnIndex(idx);
        return false;
    }

    @Override
    protected boolean _updateInf(int x, int idx) throws ContradictionException {
        if (this.isInstantiated()) {
            if (this.getValueIfInst() < x) {
                this.failOnIndex(idx);
            }
            return false;
        }
        if (x > 1) {
            this.failOnIndex(idx);
        } else if (x == 1) {
            this.restrict(1);
            this.variable.updateNbVarInstanciated();
            return true;
        }
        return false;
    }

    @Override
    protected boolean _updateSup(int x, int idx) throws ContradictionException {
        if (this.isInstantiated()) {
            if (this.getValueIfInst() > x) {
                this.failOnIndex(idx);
            }
            return false;
        }
        if (x < 0) {
            this.failOnIndex(idx);
        } else if (x == 0) {
            this.restrict(0);
            this.variable.updateNbVarInstanciated();
            return true;
        }
        return false;
    }

    @Override
    protected boolean _removeVal(int x, int idx) throws ContradictionException {
        if (this.isInstantiated()) {
            if (this.getValueIfInst() == x) {
                this.failOnIndex(idx);
            }
            return false;
        }
        if (x == 0) {
            this.restrict(1);
            this.variable.updateNbVarInstanciated();
            return true;
        }
        if (x == 1) {
            this.restrict(0);
            this.variable.updateNbVarInstanciated();
            return true;
        }
        return false;
    }

    public StoredIndexedBipartiteSet getStoredList() {
        return this.notInstanciated;
    }

    public int getOffset() {
        return this.offset;
    }

    protected static class DeltaBoolDomainIterator
    extends DisposableIntIterator {
        protected BooleanDomain domain;
        protected int val = -1;
        protected boolean disposed = true;

        private DeltaBoolDomainIterator(BooleanDomain dom) {
            this.domain = dom;
            this.init();
        }

        @Override
        public void init() {
            this.val = this.domain.getValueIfInst();
            if (this.val == 1) {
                this.val = 0;
            } else if (this.val == 0) {
                this.val = 1;
            }
            this.disposed = false;
        }

        @Override
        public void dispose() {
            this.disposed = true;
        }

        @Override
        public boolean hasNext() {
            return this.val < 2;
        }

        @Override
        public int next() {
            int temp = this.val;
            this.val = 2;
            return temp;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    protected class BitSetIntDomainIterator
    extends DisposableIntIterator {
        protected int nextValue;

        private BitSetIntDomainIterator() {
            this.init();
        }

        @Override
        public void init() {
            super.init();
            this.nextValue = BooleanDomain.this.getInf();
        }

        @Override
        public boolean hasNext() {
            return this.nextValue <= 1;
        }

        @Override
        public int next() {
            int v = this.nextValue;
            this.nextValue = v == 0 && BooleanDomain.this.notInstanciated.contain(BooleanDomain.this.offset) ? 1 : 2;
            return v;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

