/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.variables.integer;

import choco.cp.solver.variables.integer.AbstractIntDomain;
import choco.cp.solver.variables.integer.IntDomainVarImpl;
import choco.kernel.common.util.DisposableIntIterator;
import choco.kernel.memory.AbstractStateBitSet;
import choco.kernel.memory.IEnvironment;
import choco.kernel.memory.IStateInt;
import choco.kernel.solver.variables.integer.IBitSetIntDomain;
import java.util.Random;

public class BitSetIntDomain
extends AbstractIntDomain
implements IBitSetIntDomain {
    protected static final Random random = new Random();
    protected final int offset;
    protected IStateInt size;
    protected IStateInt inf;
    protected IStateInt sup;
    protected AbstractStateBitSet contents;
    protected int capacity;
    protected int[] chain;
    protected int firstIndexToBePropagated;
    protected int firstIndexBeingPropagated;
    protected DisposableIntIterator _cachedDeltaIntDomainIterator = null;

    public BitSetIntDomain(IntDomainVarImpl v, int a, int b) {
        this.variable = v;
        this.solver = v.getSolver();
        IEnvironment env = this.solver.getEnvironment();
        this.capacity = b - a + 1;
        this.offset = a;
        this.size = env.makeInt(this.capacity);
        this.contents = env.makeBitSet(this.capacity);
        for (int i = 0; i < this.capacity; ++i) {
            this.contents.set(i);
        }
        this.chain = new int[this.capacity];
        this.firstIndexToBePropagated = -1;
        this.firstIndexBeingPropagated = -1;
        this.inf = env.makeInt(a);
        this.sup = env.makeInt(b);
    }

    public BitSetIntDomain(IntDomainVarImpl v, int[] sortedValues) {
        int a = sortedValues[0];
        int b = sortedValues[sortedValues.length - 1];
        this.variable = v;
        this.solver = v.getSolver();
        IEnvironment env = this.solver.getEnvironment();
        this.capacity = b - a + 1;
        this.offset = a;
        this.size = env.makeInt(sortedValues.length);
        this.contents = env.makeBitSet(this.capacity);
        for (int i = 0; i < sortedValues.length; ++i) {
            this.contents.set(sortedValues[i] - a);
        }
        this.chain = new int[this.capacity];
        this.firstIndexToBePropagated = -1;
        this.firstIndexBeingPropagated = -1;
        this.inf = env.makeInt(a);
        this.sup = env.makeInt(b);
    }

    @Override
    public AbstractStateBitSet getContent() {
        return this.contents;
    }

    @Override
    public int getInf() {
        return this.inf.get();
    }

    @Override
    public int getSup() {
        return this.sup.get();
    }

    @Override
    public int updateInf(int x) {
        int newi = x - this.offset;
        int i = this.inf.get() - this.offset;
        while (i < newi) {
            assert (this.contents.get(i));
            this.removeIndex(i);
            i = this.contents.nextSetBit(i + 1);
        }
        this.inf.set(this.contents.nextSetBit(newi) + this.offset);
        return this.inf.get();
    }

    @Override
    public int updateSup(int x) {
        int newi = x - this.offset;
        int i = this.sup.get() - this.offset;
        while (i > newi) {
            assert (this.contents.get(i));
            this.removeIndex(i);
            i = this.contents.prevSetBit(i - 1);
        }
        this.sup.set(this.contents.prevSetBit(newi) + this.offset);
        return this.sup.get();
    }

    @Override
    public final boolean contains(int x) {
        return this.contents.get(x - this.offset);
    }

    @Override
    public boolean remove(int x) {
        int i = x - this.offset;
        if (this.contents.get(i)) {
            this.removeIndex(i);
            return true;
        }
        return false;
    }

    private void removeIndex(int i) {
        assert (i != this.firstIndexToBePropagated);
        this.contents.clear(i);
        this.chain[i] = this.firstIndexToBePropagated;
        this.firstIndexToBePropagated = i;
        assert (!this.contents.get(i));
        this.size.add(-1);
    }

    @Override
    public void restrict(int x) {
        int xi = x - this.offset;
        int i = this.contents.nextSetBit(0);
        while (i >= 0) {
            if (i != xi) {
                this.removeIndex(i);
            }
            i = this.contents.nextSetBit(i + 1);
        }
        this.sup.set(x);
        this.inf.set(x);
    }

    @Override
    public int getSize() {
        return this.size.get();
    }

    @Override
    public DisposableIntIterator getIterator() {
        if (this.getSize() == 1) {
            return DisposableIntIterator.getOneValueIterator(this.getInf());
        }
        DisposableIntIterator iter = this.lastIterator;
        if (iter != null && iter.reusable) {
            iter.init();
            return iter;
        }
        this.lastIterator = new BitSetIntDomainIterator();
        return this.lastIterator;
    }

    @Override
    public final int getNextValue(int x) {
        int i = x - this.offset;
        if (i < 0 || x < this.inf.get()) {
            return this.getInf();
        }
        int bit = this.contents.nextSetBit(i + 1);
        if (bit < 0) {
            return Integer.MAX_VALUE;
        }
        return bit + this.offset;
    }

    @Override
    public int getPrevValue(int x) {
        int i = x - this.offset;
        if (x > this.sup.get()) {
            return this.sup.get();
        }
        return this.contents.prevSetBit(i - 1) + this.offset;
    }

    @Override
    public boolean hasNextValue(int x) {
        return x < this.sup.get();
    }

    @Override
    public boolean hasPrevValue(int x) {
        return x > this.inf.get();
    }

    @Override
    public int getRandomValue() {
        int size = this.getSize();
        if (size == 1) {
            return this.getInf();
        }
        int rand = random.nextInt(size);
        int val = this.getInf() - this.offset;
        for (int o = 0; o < rand; ++o) {
            val = this.contents.nextSetBit(val + 1);
        }
        return val + this.offset;
    }

    @Override
    public boolean isEnumerated() {
        return true;
    }

    @Override
    public boolean isBoolean() {
        return this.offset == 0 && this.offset + this.capacity - 1 == 1;
    }

    @Override
    public DisposableIntIterator getDeltaIterator() {
        DeltaIntDomainIterator iter = (DeltaIntDomainIterator)this._cachedDeltaIntDomainIterator;
        if (iter != null && iter.disposed) {
            iter.init();
            return iter;
        }
        this._cachedDeltaIntDomainIterator = new DeltaIntDomainIterator(this);
        return this._cachedDeltaIntDomainIterator;
    }

    @Override
    public void freezeDeltaDomain() {
        super.freezeDeltaDomain();
        if (this.firstIndexBeingPropagated == -1) {
            this.firstIndexBeingPropagated = this.firstIndexToBePropagated;
            this.firstIndexToBePropagated = -1;
        }
    }

    @Override
    public boolean releaseDeltaDomain() {
        super.releaseDeltaDomain();
        if (this.firstIndexBeingPropagated == -1) {
            this.firstIndexToBePropagated = -1;
            return true;
        }
        this.firstIndexBeingPropagated = -1;
        return this.firstIndexToBePropagated == -1;
    }

    @Override
    public boolean getReleasedDeltaDomain() {
        return this.firstIndexBeingPropagated == -1 && this.firstIndexToBePropagated == -1;
    }

    @Override
    public void clearDeltaDomain() {
        this.firstIndexBeingPropagated = -1;
        this.firstIndexToBePropagated = -1;
    }

    public String toString() {
        return "{" + this.getInf() + "..." + this.getSup() + "}";
    }

    @Override
    public String pretty() {
        StringBuffer buf = new StringBuffer("{");
        int maxDisplay = 15;
        int count = 0;
        DisposableIntIterator it = this.getIterator();
        while (it.hasNext() && count < maxDisplay) {
            int val = it.next();
            if (++count > 1) {
                buf.append(", ");
            }
            buf.append(val);
        }
        if (this.getSize() > maxDisplay) {
            buf.append("..., ");
            buf.append(this.getSup());
        }
        buf.append("}");
        return buf.toString();
    }

    protected class DeltaIntDomainIterator
    extends DisposableIntIterator {
        protected BitSetIntDomain domain;
        protected int currentIndex = -1;
        protected boolean disposed = true;

        private DeltaIntDomainIterator(BitSetIntDomain dom) {
            this.domain = dom;
            this.currentIndex = -1;
        }

        @Override
        public void init() {
            this.currentIndex = -1;
            this.disposed = false;
        }

        @Override
        public void dispose() {
            this.disposed = true;
        }

        @Override
        public boolean hasNext() {
            if (this.currentIndex == -1) {
                return BitSetIntDomain.this.firstIndexBeingPropagated != -1;
            }
            return BitSetIntDomain.this.chain[this.currentIndex] != -1;
        }

        @Override
        public int next() {
            this.currentIndex = this.currentIndex == -1 ? BitSetIntDomain.this.firstIndexBeingPropagated : BitSetIntDomain.this.chain[this.currentIndex];
            return this.currentIndex + BitSetIntDomain.this.offset;
        }

        @Override
        public void remove() {
            if (this.currentIndex == -1) {
                throw new IllegalStateException();
            }
            throw new UnsupportedOperationException();
        }
    }

    protected class BitSetIntDomainIterator
    extends DisposableIntIterator {
        protected int nextValue;

        private BitSetIntDomainIterator() {
            this.init();
        }

        @Override
        public void init() {
            super.init();
            this.nextValue = BitSetIntDomain.this.inf.get() - BitSetIntDomain.this.offset;
        }

        @Override
        public boolean hasNext() {
            return this.nextValue >= 0;
        }

        @Override
        public int next() {
            int v = this.nextValue;
            this.nextValue = BitSetIntDomain.this.contents.nextSetBit(this.nextValue + 1);
            return v + BitSetIntDomain.this.offset;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

