/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.variables.integer;

import choco.Choco;
import choco.cp.solver.variables.integer.AbstractIntDomain;
import choco.cp.solver.variables.integer.IntDomainVarImpl;
import choco.kernel.common.util.DisposableIntIterator;
import choco.kernel.memory.IEnvironment;
import choco.kernel.memory.IStateInt;
import choco.kernel.solver.ContradictionException;
import java.util.Arrays;
import java.util.Random;

public class BipartiteIntDomain
extends AbstractIntDomain {
    protected static final Random random = new Random();
    protected int[] values;
    protected IStateInt valuesInDomainNumber;
    protected IStateInt inf;
    protected IStateInt sup;
    protected int[] indices;
    protected int offset;
    protected DisposableIntIterator _cachedDeltaIntDomainIterator = null;
    protected int beginningOfDeltaDomain;
    protected int endOfDeltaDomain;

    public BipartiteIntDomain(IntDomainVarImpl v, int[] sortedValues) {
        if (Choco.DEBUG) {
            if (v == null) {
                System.err.println("Cannot create a domain without a not null variable !");
                System.exit(-1);
            }
            if (sortedValues == null) {
                System.err.println("Variable " + v + " cannot have an empty domain at the beginning !");
                System.exit(-1);
            }
        }
        this.init(v, sortedValues);
    }

    public BipartiteIntDomain(IntDomainVarImpl v, int low, int up) {
        if (Choco.DEBUG) {
            if (v == null) {
                System.err.println("Cannot create a domain without a not null variable !");
                System.exit(-1);
            }
            if (low > up) {
                System.err.println("Variable " + v + " cannot have an empty domain at the beginning !");
                System.exit(-1);
            }
        }
        int[] sortedValues = new int[up - low + 1];
        for (int i = 0; i < sortedValues.length; ++i) {
            sortedValues[i] = low + i;
        }
        this.init(v, sortedValues);
    }

    public void init(IntDomainVarImpl v, int[] sortedValues) {
        int i;
        this.variable = v;
        this.solver = v.getSolver();
        IEnvironment env = this.solver.getEnvironment();
        int low = sortedValues[0];
        int up = sortedValues[sortedValues.length - 1];
        int size = sortedValues.length;
        this.offset = low;
        this.values = new int[size];
        for (i = 0; i < sortedValues.length; ++i) {
            this.values[i] = sortedValues[i];
        }
        this.valuesInDomainNumber = env.makeInt(size - 1);
        this.indices = new int[up - low + 1];
        Arrays.fill(this.indices, Integer.MAX_VALUE);
        for (i = 0; i < this.values.length; ++i) {
            this.indices[this.values[i] - this.offset] = i;
        }
        this.endOfDeltaDomain = size;
        this.beginningOfDeltaDomain = size;
        this.inf = env.makeInt(low);
        this.sup = env.makeInt(up);
    }

    @Override
    public int getInf() {
        return this.inf.get();
    }

    @Override
    public int getSup() {
        return this.sup.get();
    }

    @Override
    public boolean contains(int x) {
        return this.indices[x - this.offset] <= this.valuesInDomainNumber.get();
    }

    @Override
    public int getSize() {
        return this.valuesInDomainNumber.get() + 1;
    }

    @Override
    public int getNextValue(int x) {
        if (x >= this.getSup()) {
            return Integer.MAX_VALUE;
        }
        int nextval = Integer.MAX_VALUE;
        for (int i = this.valuesInDomainNumber.get(); i >= 0; --i) {
            if (this.values[i] <= x || this.values[i] >= nextval) continue;
            nextval = this.values[i];
        }
        return nextval;
    }

    @Override
    public int getPrevValue(int x) {
        if (x <= this.getInf()) {
            return Integer.MAX_VALUE;
        }
        int prevval = Integer.MIN_VALUE;
        for (int i = this.valuesInDomainNumber.get(); i >= 0; --i) {
            if (this.values[i] >= x || this.values[i] <= prevval) continue;
            prevval = this.values[i];
        }
        return prevval;
    }

    @Override
    public boolean hasNextValue(int x) {
        return x < this.getSup();
    }

    @Override
    public boolean hasPrevValue(int x) {
        return x > this.getInf();
    }

    @Override
    public boolean removeInterval(int a, int b, int idx) throws ContradictionException {
        if (a <= this.getInf()) {
            return this.updateInf(b + 1, idx);
        }
        if (this.getSup() <= b) {
            return this.updateSup(a - 1, idx);
        }
        boolean anyChange = false;
        for (int i = this.valuesInDomainNumber.get(); i >= 0; --i) {
            int v = this.values[i];
            if (v < a || v > b) continue;
            anyChange |= this.removeVal(v, idx);
        }
        return anyChange;
    }

    @Override
    protected boolean _removeVal(int x, int idx) throws ContradictionException {
        int infv = this.getInf();
        int supv = this.getSup();
        if (infv <= x && x <= supv) {
            boolean b = this.remove(x);
            if (x == infv) {
                int possibleninf = x + 1;
                if (possibleninf > supv) {
                    if (idx == -1) {
                        this.getSolver().getPropagationEngine().raiseContradiction(this.variable, 1);
                    } else {
                        this.getSolver().getPropagationEngine().raiseContradiction(this.variable.getConstraintVector().get(idx), 2);
                    }
                }
                int min = Integer.MAX_VALUE;
                for (int i = this.valuesInDomainNumber.get(); i >= 0 && (this.values[i] >= min || (min = this.values[i]) != possibleninf); --i) {
                }
                this.inf.set(min);
                if (min == supv) {
                    this.variable.updateNbVarInstanciated();
                }
                return b;
            }
            if (x == supv) {
                int possiblesup = x - 1;
                if (possiblesup < infv) {
                    if (idx == -1) {
                        this.getSolver().getPropagationEngine().raiseContradiction(this.variable, 1);
                    } else {
                        this.getSolver().getPropagationEngine().raiseContradiction(this.variable.getConstraintVector().get(idx), 2);
                    }
                }
                int max = Integer.MIN_VALUE;
                for (int i = this.valuesInDomainNumber.get(); i >= 0 && (this.values[i] <= max || (max = this.values[i]) != possiblesup); --i) {
                }
                this.sup.set(max);
                if (max == infv) {
                    this.variable.updateNbVarInstanciated();
                }
                return b;
            }
            return b;
        }
        return false;
    }

    @Override
    public boolean remove(int x) {
        int i = x - this.offset;
        int mark = this.valuesInDomainNumber.get();
        if (this.indices[i] <= mark) {
            if (this.indices[i] < mark) {
                int tempval = this.values[mark];
                this.values[mark] = x;
                this.values[this.indices[i]] = tempval;
                this.indices[tempval - this.offset] = this.indices[i];
                this.indices[i] = mark;
            }
            this.valuesInDomainNumber.add(-1);
            if (this.endOfDeltaDomain <= mark) {
                this.endOfDeltaDomain = mark + 1;
            }
            return true;
        }
        return false;
    }

    @Override
    public void restrict(int x) {
        int i = x - this.offset;
        int tempval = this.values[0];
        this.values[0] = x;
        this.values[this.indices[i]] = tempval;
        this.indices[tempval - this.offset] = this.indices[i];
        this.indices[i] = 0;
        this.inf.set(x);
        this.sup.set(x);
        if (this.endOfDeltaDomain <= this.valuesInDomainNumber.get()) {
            this.endOfDeltaDomain = this.valuesInDomainNumber.get() + 1;
        }
        this.valuesInDomainNumber.set(0);
    }

    @Override
    public int updateInf(int x) {
        int min = Integer.MAX_VALUE;
        for (int i = this.valuesInDomainNumber.get(); i >= 0; --i) {
            if (this.values[i] < x) {
                this.remove(this.values[i]);
                continue;
            }
            if (this.values[i] >= min) continue;
            min = this.values[i];
        }
        this.inf.set(min);
        return min;
    }

    @Override
    public int updateSup(int x) {
        int max = Integer.MIN_VALUE;
        for (int i = this.valuesInDomainNumber.get(); i >= 0; --i) {
            if (this.values[i] > x) {
                this.remove(this.values[i]);
                continue;
            }
            if (this.values[i] <= max) continue;
            max = this.values[i];
        }
        this.sup.set(max);
        return max;
    }

    @Override
    public int getRandomValue() {
        if (this.getSize() == 1) {
            return this.values[0];
        }
        return this.values[random.nextInt(this.valuesInDomainNumber.get() + 1)];
    }

    @Override
    public DisposableIntIterator getIterator() {
        if (this.getSize() == 1) {
            return DisposableIntIterator.getOneValueIterator(this.getInf());
        }
        BipartiteIntDomainIterator iter = (BipartiteIntDomainIterator)this.lastIterator;
        if (iter != null && iter.reusable) {
            iter.init();
            return iter;
        }
        this.lastIterator = new BipartiteIntDomainIterator();
        return this.lastIterator;
    }

    @Override
    public DisposableIntIterator getDeltaIterator() {
        DeltaBipartiteIterator iter = (DeltaBipartiteIterator)this._cachedDeltaIntDomainIterator;
        if (iter != null && iter.disposed) {
            iter.init();
            return iter;
        }
        this._cachedDeltaIntDomainIterator = new DeltaBipartiteIterator(this);
        return this._cachedDeltaIntDomainIterator;
    }

    @Override
    public void freezeDeltaDomain() {
        super.freezeDeltaDomain();
        this.beginningOfDeltaDomain = this.valuesInDomainNumber.get() + 1;
    }

    @Override
    public boolean releaseDeltaDomain() {
        super.releaseDeltaDomain();
        this.endOfDeltaDomain = this.beginningOfDeltaDomain;
        this.beginningOfDeltaDomain = this.valuesInDomainNumber.get() + 1;
        return this.beginningOfDeltaDomain == this.endOfDeltaDomain;
    }

    @Override
    public boolean getReleasedDeltaDomain() {
        return this.beginningOfDeltaDomain == this.endOfDeltaDomain;
    }

    @Override
    public void clearDeltaDomain() {
        this.endOfDeltaDomain = this.beginningOfDeltaDomain = this.valuesInDomainNumber.get() + 1;
    }

    @Override
    public boolean isEnumerated() {
        return true;
    }

    @Override
    public boolean isBoolean() {
        return false;
    }

    @Override
    public String pretty() {
        StringBuffer buf = new StringBuffer("{");
        int maxDisplay = 15;
        int count = 0;
        DisposableIntIterator it = this.getIterator();
        while (it.hasNext() && count < maxDisplay) {
            int val = it.next();
            if (++count > 1) {
                buf.append(", ");
            }
            buf.append(val);
        }
        if (this.getSize() > maxDisplay) {
            buf.append("..., ");
            buf.append(this.getSup());
        }
        buf.append("}");
        return buf.toString();
    }

    protected class DeltaBipartiteIterator
    extends DisposableIntIterator {
        protected BipartiteIntDomain domain;
        protected int currentIndex = -1;
        protected boolean disposed = true;

        private DeltaBipartiteIterator(BipartiteIntDomain dom) {
            this.domain = dom;
            this.init();
        }

        @Override
        public void init() {
            this.currentIndex = BipartiteIntDomain.this.beginningOfDeltaDomain;
            this.disposed = false;
        }

        @Override
        public void dispose() {
            this.disposed = true;
        }

        @Override
        public boolean hasNext() {
            return this.currentIndex < BipartiteIntDomain.this.endOfDeltaDomain;
        }

        @Override
        public int next() {
            return BipartiteIntDomain.this.values[this.currentIndex++];
        }

        @Override
        public void remove() {
            if (this.currentIndex == -1) {
                throw new IllegalStateException();
            }
            throw new UnsupportedOperationException();
        }
    }

    protected class BipartiteIntDomainIterator
    extends DisposableIntIterator {
        protected int nextIdx;

        private BipartiteIntDomainIterator() {
            this.init();
        }

        @Override
        public void init() {
            super.init();
            this.nextIdx = BipartiteIntDomain.this.valuesInDomainNumber.get();
        }

        @Override
        public boolean hasNext() {
            return this.nextIdx >= 0;
        }

        @Override
        public int next() {
            int v = this.nextIdx--;
            return BipartiteIntDomain.this.values[v];
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

