/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.variables.integer;

import choco.cp.solver.variables.integer.IntDomainVarImpl;
import choco.kernel.common.util.DisposableIntIterator;
import choco.kernel.solver.ContradictionException;
import choco.kernel.solver.Solver;
import choco.kernel.solver.variables.integer.IntDomain;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class AbstractIntDomain
implements IntDomain {
    public Solver solver;
    protected static Logger logger = Logger.getLogger("choco.kernel.solver.propagation");
    protected IntDomainVarImpl variable;
    protected int currentInfPropagated;
    protected int currentSupPropagated;
    protected DisposableIntIterator lastIterator;

    @Override
    public DisposableIntIterator getIterator() {
        IntDomainIterator iter = (IntDomainIterator)this.lastIterator;
        if (iter != null && iter.reusable) {
            iter.init();
            return iter;
        }
        this.lastIterator = new IntDomainIterator(this);
        return this.lastIterator;
    }

    public boolean updateSup(int x, int idx) throws ContradictionException {
        if (this._updateSup(x, idx)) {
            int cause = -1;
            int val = this.getInf();
            if (this.getSup() == x) {
                cause = idx;
            }
            if (val == this.getSup()) {
                this.restrict(val);
                this.variable.updateNbVarInstanciated();
                this.solver.getPropagationEngine().postInstInt(this.variable, cause);
            } else {
                this.solver.getPropagationEngine().postUpdateSup(this.variable, cause);
            }
            return true;
        }
        return false;
    }

    public boolean updateInf(int x, int idx) throws ContradictionException {
        if (this._updateInf(x, idx)) {
            int cause = -1;
            int val = this.getSup();
            if (this.getInf() == x) {
                cause = idx;
            }
            if (val == this.getInf()) {
                this.restrict(val);
                this.variable.updateNbVarInstanciated();
                this.solver.getPropagationEngine().postInstInt(this.variable, cause);
            } else {
                this.solver.getPropagationEngine().postUpdateInf(this.variable, cause);
            }
            return true;
        }
        return false;
    }

    public boolean removeVal(int x, int idx) throws ContradictionException {
        if (this._removeVal(x, idx)) {
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest("REM(" + this.toString() + "): " + x);
            }
            int promoteCause = -1;
            if (this.getInf() == this.getSup()) {
                this.solver.getPropagationEngine().postInstInt(this.variable, promoteCause);
            } else if (x < this.getInf()) {
                this.solver.getPropagationEngine().postUpdateInf(this.variable, promoteCause);
            } else if (x > this.getSup()) {
                this.solver.getPropagationEngine().postUpdateSup(this.variable, promoteCause);
            } else {
                this.solver.getPropagationEngine().postRemoveVal(this.variable, x, idx);
            }
            return true;
        }
        return false;
    }

    public boolean removeInterval(int a, int b, int idx) throws ContradictionException {
        if (a <= this.getInf()) {
            return this.updateInf(b + 1, idx);
        }
        if (this.getSup() <= b) {
            return this.updateSup(a - 1, idx);
        }
        if (this.variable.hasEnumeratedDomain()) {
            boolean anyChange = false;
            int v = this.getNextValue(a - 1);
            while (v <= b) {
                anyChange |= this.removeVal(v, idx);
                v = this.getNextValue(v);
            }
            return anyChange;
        }
        return false;
    }

    public boolean instantiate(int x, int idx) throws ContradictionException {
        if (this._instantiate(x, idx)) {
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest("INST(" + this.toString() + "): " + x);
            }
            this.solver.getPropagationEngine().postInstInt(this.variable, idx);
            return true;
        }
        return false;
    }

    protected boolean _instantiate(int x, int idx) throws ContradictionException {
        if (this.variable.isInstantiated()) {
            if (this.variable.getVal() != x) {
                if (idx == -1) {
                    this.getSolver().getPropagationEngine().raiseContradiction(this.variable, 1);
                } else {
                    this.getSolver().getPropagationEngine().raiseContradiction(this.variable.getConstraintVector().get(idx), 2);
                }
                return true;
            }
            return false;
        }
        if (x < this.getInf() || x > this.getSup() || !this.contains(x)) {
            if (idx == -1) {
                this.getSolver().getPropagationEngine().raiseContradiction(this.variable, 1);
            } else {
                this.getSolver().getPropagationEngine().raiseContradiction(this.variable.getConstraintVector().get(idx), 2);
            }
            return true;
        }
        this.restrict(x);
        this.variable.updateNbVarInstanciated();
        return true;
    }

    protected boolean _updateInf(int x, int idx) throws ContradictionException {
        if (x > this.getInf()) {
            if (x > this.getSup()) {
                if (idx == -1) {
                    this.getSolver().getPropagationEngine().raiseContradiction(this.variable, 1);
                } else {
                    this.getSolver().getPropagationEngine().raiseContradiction(this.variable.getConstraintVector().get(idx), 2);
                }
                return true;
            }
            this.updateInf(x);
            return true;
        }
        return false;
    }

    protected boolean _updateSup(int x, int idx) throws ContradictionException {
        if (x < this.getSup()) {
            if (x < this.getInf()) {
                if (idx == -1) {
                    this.getSolver().getPropagationEngine().raiseContradiction(this.variable, 1);
                } else {
                    this.getSolver().getPropagationEngine().raiseContradiction(this.variable.getConstraintVector().get(idx), 2);
                }
                return true;
            }
            this.updateSup(x);
            return true;
        }
        return false;
    }

    protected boolean _removeVal(int x, int idx) throws ContradictionException {
        int infv = this.getInf();
        int supv = this.getSup();
        if (infv <= x && x <= supv) {
            if (x == infv) {
                this._updateInf(x + 1, idx);
                if (this.getInf() == supv) {
                    this.restrict(supv);
                    this.variable.updateNbVarInstanciated();
                }
                return true;
            }
            if (x == supv) {
                this._updateSup(x - 1, idx);
                if (this.getSup() == infv) {
                    this.restrict(infv);
                    this.variable.updateNbVarInstanciated();
                }
                return true;
            }
            return this.remove(x);
        }
        return false;
    }

    @Override
    public void freezeDeltaDomain() {
        this.currentInfPropagated = this.getInf();
        this.currentSupPropagated = this.getSup();
    }

    @Override
    public boolean releaseDeltaDomain() {
        boolean noNewUpdate = this.getInf() == this.currentInfPropagated && this.getSup() == this.currentSupPropagated;
        this.currentInfPropagated = Integer.MIN_VALUE;
        this.currentSupPropagated = Integer.MAX_VALUE;
        return noNewUpdate;
    }

    @Override
    public void clearDeltaDomain() {
        this.currentInfPropagated = Integer.MIN_VALUE;
        this.currentSupPropagated = Integer.MAX_VALUE;
    }

    @Override
    public boolean getReleasedDeltaDomain() {
        return true;
    }

    @Override
    public Solver getSolver() {
        return this.solver;
    }

    @Override
    public void setSolver(Solver solver) {
        this.solver = solver;
    }

    protected static class IntDomainIterator
    extends DisposableIntIterator {
        protected AbstractIntDomain domain;
        protected int nextValue;
        protected int supBound = -1;

        private IntDomainIterator(AbstractIntDomain dom) {
            this.domain = dom;
            this.init();
        }

        @Override
        public void init() {
            super.init();
            if (this.domain.getSize() < 1) {
                throw new UnsupportedOperationException();
            }
            this.nextValue = this.domain.getInf();
            this.supBound = this.domain.getSup();
        }

        @Override
        public boolean hasNext() {
            return this.nextValue <= this.supBound;
        }

        @Override
        public int next() {
            int v = this.nextValue;
            this.nextValue = this.domain.getNextValue(this.nextValue);
            return v;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

