/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.search.task;

import choco.cp.solver.search.task.SetTimesNode;
import choco.kernel.memory.IEnvironment;
import choco.kernel.memory.IStateInt;
import choco.kernel.memory.trailing.StoredBitSet;
import choco.kernel.solver.ContradictionException;
import choco.kernel.solver.Solver;
import choco.kernel.solver.branch.AbstractLargeIntBranching;
import choco.kernel.solver.search.task.RandomizedTaskSelector;
import choco.kernel.solver.search.task.TaskSelector;
import choco.kernel.solver.search.task.TaskVarSelector;
import choco.kernel.solver.variables.scheduling.ITask;
import choco.kernel.solver.variables.scheduling.TaskVar;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;

public class SetTimes
extends AbstractLargeIntBranching {
    protected final IStateInt[] flags;
    protected final StoredBitSet select;
    protected final StoredBitSet nselect;
    protected final List<TaskVar> tasksL;
    protected final Map<TaskVar, Integer> taskIndexM;
    protected final TaskVarSelector selector;

    public SetTimes(Solver solver, List<TaskVar> tasks, Comparator<ITask> comparator, boolean randomized) {
        this(solver, tasks, randomized ? new RandomizedTaskSelector(comparator) : new TaskSelector(comparator));
    }

    public SetTimes(Solver solver, List<TaskVar> tasks, TaskVarSelector selector) {
        this.tasksL = new ArrayList<TaskVar>(tasks);
        this.taskIndexM = new HashMap<TaskVar, Integer>(this.tasksL.size());
        this.selector = selector;
        IEnvironment env = solver.getEnvironment();
        this.select = (StoredBitSet)env.makeBitSet(tasks.size());
        this.select.set(0, this.tasksL.size());
        this.nselect = (StoredBitSet)env.makeBitSet(tasks.size());
        this.flags = new IStateInt[this.tasksL.size()];
        for (int i = 0; i < this.flags.length; ++i) {
            this.flags[i] = env.makeInt();
            this.taskIndexM.put(this.tasksL.get(i), i);
        }
        this.LOG_DECISION_MSG = new String[]{"=="};
    }

    @Override
    public String getDecisionLogMsg(int branchIndex) {
        return this.LOG_DECISION_MSG[0];
    }

    @Override
    public boolean finishedBranching(Object x, int i) {
        SetTimesNode n = (SetTimesNode)x;
        return n.selectables.isEmpty();
    }

    @Override
    public int getFirstBranch(Object x) {
        return 1;
    }

    @Override
    public int getNextBranch(Object x, int i) {
        return i + 1;
    }

    @Override
    public Object selectBranchingObject() throws ContradictionException {
        int i = this.nselect.nextSetBit(0);
        while (i >= 0) {
            if (this.tasksL.get(i).getEST() != this.flags[i].get()) {
                this.select.set(i);
                this.nselect.clear(i);
            }
            i = this.nselect.nextSetBit(i + 1);
        }
        LinkedHashSet<TaskVar> l = new LinkedHashSet<TaskVar>(this.select.cardinality());
        int i2 = this.select.nextSetBit(0);
        while (i2 >= 0) {
            if (this.tasksL.get(i2).isScheduled()) {
                this.select.clear(i2);
            } else {
                l.add(this.tasksL.get(i2));
            }
            i2 = this.select.nextSetBit(i2 + 1);
        }
        return l.isEmpty() ? null : new SetTimesNode(l);
    }

    @Override
    public void goDownBranch(Object x, int i) throws ContradictionException {
        SetTimesNode n = (SetTimesNode)x;
        TaskVar s = this.selector.selectTaskVar(n.selectables);
        n.setLastSelected(s);
        this.logDownBranch(s, i);
        s.start().setVal(s.getEST());
    }

    @Override
    public void goUpBranch(Object x, int i) throws ContradictionException {
        SetTimesNode n = (SetTimesNode)x;
        TaskVar t = n.getLastSelected();
        n.removeLastSelected();
        this.logUpBranch(t, i);
        int idx = this.taskIndexM.get(t);
        this.nselect.set(idx);
        this.flags[idx].set(t.getEST());
    }

    protected final String getDecisionLogMsg(TaskVar selected, int i) {
        return selected.start().toString() + this.getDecisionLogMsg(i) + selected.getEST();
    }

    @Override
    protected void logDownBranch(Object x, int i) {
        int n;
        if (logger.isLoggable(Level.FINE) && (n = this.manager.solver.getEnvironment().getWorldIndex()) <= this.manager.getLoggingMaxDepth()) {
            logger.log(Level.FINE, LOG_DOWN_MSG, new Object[]{n, this.getDecisionLogMsg((TaskVar)x, i), " branch ", i});
        }
    }

    @Override
    protected void logUpBranch(Object x, int i) {
        int n;
        if (logger.isLoggable(Level.FINE) && (n = this.manager.solver.getEnvironment().getWorldIndex()) <= this.manager.getLoggingMaxDepth()) {
            logger.log(Level.FINE, LOG_UP_MSG, new Object[]{n + 1, this.getDecisionLogMsg((TaskVar)x, i), " branch ", i});
        }
    }
}

