/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.search.set;

import choco.cp.solver.variables.set.SetVarImpl;
import choco.kernel.solver.Solver;
import choco.kernel.solver.search.set.AbstractSetVarSelector;
import choco.kernel.solver.search.set.SetVarSelector;
import choco.kernel.solver.variables.set.SetVar;
import java.util.ArrayList;
import java.util.Random;

public class RandomSetVarSelector
extends AbstractSetVarSelector
implements SetVarSelector {
    protected ArrayList<SetVar> list = new ArrayList();
    protected Random random;

    public RandomSetVarSelector(Solver solver) {
        this.solver = solver;
        this.random = new Random();
    }

    public RandomSetVarSelector(Solver solver, SetVar[] vs, long seed) {
        this.solver = solver;
        this.vars = vs;
        this.random = new Random(seed);
    }

    public RandomSetVarSelector(Solver solver, long seed) {
        this.solver = solver;
        this.random = new Random(seed);
    }

    @Override
    public SetVar selectSetVar() {
        if (this.vars == null) {
            for (int i = 0; i < this.solver.getNbSetVars(); ++i) {
                SetVar v = this.solver.getSetVar(i);
                if (v.isInstantiated()) continue;
                this.list.add(v);
            }
        } else {
            for (SetVar v : this.vars) {
                if (v.isInstantiated()) continue;
                this.list.add(v);
            }
        }
        SetVarImpl ret = null;
        if (this.list.size() > 0) {
            ret = (SetVarImpl)this.list.get(this.random.nextInt(this.list.size()));
        }
        this.list.clear();
        return ret;
    }
}

