/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.search.set;

import choco.kernel.solver.Solver;
import choco.kernel.solver.search.set.AbstractSetVarSelector;
import choco.kernel.solver.variables.set.SetVar;

public class MinDomSet
extends AbstractSetVarSelector {
    public MinDomSet(Solver solver, SetVar[] decisionvs) {
        this.vars = decisionvs;
        this.solver = solver;
    }

    public MinDomSet(Solver solver) {
        this.solver = solver;
    }

    @Override
    public SetVar selectSetVar() {
        int minDomSize = Integer.MAX_VALUE;
        SetVar v0 = null;
        if (null != this.vars) {
            for (SetVar v : this.vars) {
                int domSize;
                if (v.isInstantiated() || (domSize = v.getEnveloppeDomainSize() - v.getKernelDomainSize()) >= minDomSize) continue;
                minDomSize = domSize;
                v0 = v;
            }
        } else {
            int n = this.solver.getNbSetVars();
            for (int i = 0; i < n; ++i) {
                int domSize;
                SetVar v = this.solver.getSetVar(i);
                if (v.isInstantiated() || (domSize = v.getEnveloppeDomainSize() - v.getKernelDomainSize()) >= minDomSize) continue;
                minDomSize = domSize;
                v0 = v;
            }
        }
        return v0;
    }
}

