/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.search.restart;

import choco.cp.solver.search.restart.GeometricalRestart;
import choco.kernel.solver.SolverException;
import choco.kernel.solver.search.Limit;

public class LubyRestart
extends GeometricalRestart {
    private int geometricalIntFactor;
    private int divFactor;

    public LubyRestart(Limit type, int scaleFactor) {
        super(type, 2.0, scaleFactor);
    }

    public LubyRestart(Limit type, int geometricalFactor, int scaleFactor) {
        super(type, geometricalFactor, scaleFactor);
    }

    @Override
    public final void setGeometricalFactor(double geometricalFactor) {
        double f = Math.floor(geometricalFactor);
        if (f != geometricalFactor) {
            throw new SolverException("Luby geometrical parameter should be an integer");
        }
        super.setGeometricalFactor(geometricalFactor);
        this.geometricalIntFactor = (int)geometricalFactor;
        this.divFactor = this.geometricalIntFactor - 1;
    }

    public static final int pow(int value, int exp) {
        return value == 2 ? 1 << exp : (int)Math.pow(value, exp);
    }

    public static final double log(double value, double exponent) {
        return Math.log(value) / Math.log(exponent);
    }

    public static final int geometricalSum(int value, int exponent) {
        return (LubyRestart.pow(value, exponent) - 1) / (value - 1);
    }

    public final int getLasVegasCoef(int i) {
        int k;
        double log = LubyRestart.log(i * this.divFactor + 1, this.geometricalIntFactor);
        if (log == (double)(k = (int)Math.floor(log))) {
            return LubyRestart.pow(this.geometricalIntFactor, k - 1);
        }
        return this.getLasVegasCoef(i - LubyRestart.geometricalSum(this.geometricalIntFactor, k));
    }

    @Override
    protected int getNextLimit() {
        return this.getLasVegasCoef(this.nbRestarts + 1) * this.scaleFactor;
    }
}

