/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.search.restart;

import choco.cp.solver.search.restart.AbstractRestartStrategyOnLimit;
import choco.kernel.solver.SolverException;
import choco.kernel.solver.search.Limit;

public class GeometricalRestart
extends AbstractRestartStrategyOnLimit {
    protected int scaleFactor = 1;
    protected double geometricalFactor = 1.0;

    public GeometricalRestart(Limit type, double geometricalFactor, int scaleFactor) {
        super(type, scaleFactor);
        this.scaleFactor = scaleFactor;
        this.setGeometricalFactor(geometricalFactor);
    }

    protected void checkNonNegative(double v) {
        if (v < 1.0) {
            throw new SolverException("paramter should be a positive number");
        }
    }

    public final int getScaleFactor() {
        return this.scaleFactor;
    }

    public final void setScaleFactor(int scaleFactor) {
        this.checkNonNegative(scaleFactor);
        this.scaleFactor = scaleFactor;
    }

    public final double getGeometricalFactor() {
        return this.geometricalFactor;
    }

    public void setGeometricalFactor(double geometricalFactor) {
        this.checkNonNegative(geometricalFactor);
        this.geometricalFactor = geometricalFactor;
    }

    @Override
    protected int getNextLimit() {
        return (int)Math.ceil(Math.pow(this.geometricalFactor, this.nbRestarts) * (double)this.scaleFactor);
    }
}

