/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.search.restart;

import choco.cp.solver.search.restart.RestartStrategy;
import choco.kernel.solver.SolverException;
import choco.kernel.solver.search.AbstractGlobalSearchLimit;
import choco.kernel.solver.search.AbstractGlobalSearchStrategy;
import choco.kernel.solver.search.Limit;

public abstract class AbstractRestartStrategyOnLimit
implements RestartStrategy {
    protected int nbRestarts = 0;
    protected final Limit type;
    protected AbstractGlobalSearchLimit failLimit;
    private int currentLimit;

    public AbstractRestartStrategyOnLimit(Limit failLimit, int initialLimit) {
        this.type = failLimit;
        this.currentLimit = initialLimit;
        if (this.currentLimit < 1) {
            throw new SolverException("initial restart limit shoud be strictly positive.");
        }
    }

    public final Limit getLimit() {
        return this.type;
    }

    public final AbstractGlobalSearchLimit getFailLimit() {
        return this.failLimit;
    }

    public final void setFailLimit(AbstractGlobalSearchLimit failLimit) {
        this.failLimit = failLimit;
    }

    public final int getCurrentLimit() {
        return this.currentLimit;
    }

    protected abstract int getNextLimit();

    @Override
    public boolean shouldRestart(AbstractGlobalSearchStrategy search) {
        boolean shouldRestart;
        boolean bl = shouldRestart = this.failLimit.getNb() >= this.currentLimit;
        if (shouldRestart) {
            ++this.nbRestarts;
            this.currentLimit = this.getNextLimit();
        }
        return shouldRestart;
    }

    public int[] getExample(int lenght) {
        int[] r = new int[lenght];
        this.nbRestarts = 0;
        r[0] = this.getCurrentLimit();
        for (int i = 1; i < r.length; ++i) {
            ++this.nbRestarts;
            r[i] = this.getNextLimit();
        }
        this.nbRestarts = 0;
        return r;
    }
}

