/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.search.real;

import choco.kernel.solver.Solver;
import choco.kernel.solver.search.real.AbstractRealVarSelector;
import choco.kernel.solver.search.real.RealVarSelector;
import choco.kernel.solver.variables.real.RealVar;

public class CyclicRealVarSelector
extends AbstractRealVarSelector
implements RealVarSelector {
    protected int current;

    public CyclicRealVarSelector(Solver solver) {
        this.solver = solver;
        this.current = -1;
    }

    @Override
    public RealVar selectRealVar() {
        int nbvars = this.solver.getNbRealVars();
        if (nbvars == 0) {
            return null;
        }
        int start = this.current == -1 ? nbvars - 1 : this.current;
        int n = (this.current + 1) % nbvars;
        while (n != start && this.solver.getRealVar(n).isInstantiated()) {
            n = (n + 1) % nbvars;
        }
        if (this.solver.getRealVar(n).isInstantiated()) {
            return null;
        }
        this.current = n;
        return this.solver.getRealVar(n);
    }
}

