/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.search.real;

import choco.kernel.solver.ContradictionException;
import choco.kernel.solver.branch.AbstractIntBranching;
import choco.kernel.solver.branch.IntBranching;
import choco.kernel.solver.search.integer.ValIterator;
import choco.kernel.solver.search.real.RealVarSelector;
import choco.kernel.solver.variables.real.RealMath;
import choco.kernel.solver.variables.real.RealVar;
import java.util.logging.Level;

public class AssignInterval
extends AbstractIntBranching
implements IntBranching {
    protected RealVarSelector varSelector;
    protected ValIterator valIterator;
    String[] LOG_DECISION_MSG = new String[]{"in first half of", "in second half of"};

    public AssignInterval(RealVarSelector varSelector, ValIterator valIterator) {
        this.varSelector = varSelector;
        this.valIterator = valIterator;
    }

    @Override
    public Object selectBranchingObject() throws ContradictionException {
        return this.varSelector.selectRealVar();
    }

    @Override
    public void goDownBranch(Object x, int i) throws ContradictionException {
        super.goDownBranch(x, i);
        if (i == 1) {
            ((RealVar)x).intersect(RealMath.firstHalf((RealVar)x));
            this.manager.solver.propagate();
        } else if (i == 2) {
            ((RealVar)x).intersect(RealMath.secondHalf((RealVar)x));
            this.manager.solver.propagate();
        } else if (logger.isLoggable(Level.SEVERE)) {
            logger.severe("!! Not a valid value for AssignInterval branching !!");
        }
    }

    @Override
    public void goUpBranch(Object x, int i) throws ContradictionException {
        super.goUpBranch(x, i);
    }

    @Override
    public int getFirstBranch(Object x) {
        return this.valIterator.getFirstVal((RealVar)x);
    }

    @Override
    public int getNextBranch(Object x, int i) {
        return this.valIterator.getNextVal((RealVar)x, i);
    }

    @Override
    public boolean finishedBranching(Object x, int i) {
        return !this.valIterator.hasNextVal((RealVar)x, i);
    }

    @Override
    public String getDecisionLogMsg(int i) {
        if (i == 1) {
            return this.LOG_DECISION_MSG[0];
        }
        if (i == 2) {
            return this.LOG_DECISION_MSG[1];
        }
        return "";
    }
}

