/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.search.real;

import choco.cp.solver.search.SearchLoop;
import choco.kernel.solver.ContradictionException;
import choco.kernel.solver.search.AbstractGlobalSearchStrategy;
import choco.kernel.solver.variables.real.RealIntervalConstant;
import choco.kernel.solver.variables.real.RealMath;
import choco.kernel.solver.variables.real.RealVar;

public abstract class AbstractRealOptimize
extends AbstractGlobalSearchStrategy {
    public boolean doMaximize;
    public RealVar objective;
    public double lowerBound = Double.NEGATIVE_INFINITY;
    public double upperBound = Double.POSITIVE_INFINITY;
    public double targetUpperBound = Double.POSITIVE_INFINITY;
    public double targetLowerBound = Double.NEGATIVE_INFINITY;

    protected AbstractRealOptimize(RealVar obj, boolean maximize) {
        super(obj.getSolver());
        this.setSearchLoop(new SearchLoop(this));
        this.objective = obj;
        this.doMaximize = maximize;
    }

    public double getObjectiveValue() {
        if (this.doMaximize) {
            return this.objective.getSup();
        }
        return this.objective.getInf();
    }

    public double getBestObjectiveValue() {
        if (this.doMaximize) {
            return this.lowerBound;
        }
        return this.upperBound;
    }

    public double getObjectiveTarget() {
        if (this.doMaximize) {
            return this.targetLowerBound;
        }
        return this.targetUpperBound;
    }

    public void initBounds() {
        this.lowerBound = this.objective.getInf();
        this.upperBound = this.objective.getSup();
        this.targetLowerBound = this.objective.getInf();
        this.targetUpperBound = this.objective.getSup();
    }

    @Override
    public void recordSolution() {
        this.solver.setFeasible(Boolean.TRUE);
        logger.info("... solution with cost " + this.objective + ":" + this.objective.getValue());
        this.setBound();
        this.setTargetBound();
        super.recordSolution();
    }

    public void setBound() {
        double objval = this.getObjectiveValue();
        if (this.doMaximize) {
            this.lowerBound = Math.max(this.lowerBound, objval);
        } else {
            this.upperBound = Math.min(this.upperBound, objval);
        }
    }

    public void setTargetBound() {
        if (this.doMaximize) {
            this.setTargetLowerBound();
        } else {
            this.setTargetUpperBound();
        }
    }

    protected void setTargetLowerBound() {
        double newBound = RealMath.nextFloat(this.lowerBound);
        if (this.solver.getFeasible() == Boolean.TRUE) {
            this.targetLowerBound = newBound;
        }
    }

    protected void setTargetUpperBound() {
        double newBound = RealMath.prevFloat(this.upperBound);
        if (this.solver.getFeasible() == Boolean.TRUE) {
            this.targetUpperBound = newBound;
        }
    }

    public void postTargetBound() throws ContradictionException {
        if (this.doMaximize) {
            this.postTargetLowerBound();
        } else {
            this.postTargetUpperBound();
        }
    }

    public void postTargetLowerBound() throws ContradictionException {
        this.objective.intersect(new RealIntervalConstant(this.targetLowerBound, Double.POSITIVE_INFINITY));
    }

    public void postTargetUpperBound() throws ContradictionException {
        this.objective.intersect(new RealIntervalConstant(Double.NEGATIVE_INFINITY, this.targetUpperBound));
    }

    @Override
    public void postDynamicCut() throws ContradictionException {
        this.postTargetBound();
    }
}

