/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.search.limit;

import choco.kernel.solver.search.AbstractGlobalSearchLimit;
import choco.kernel.solver.search.AbstractGlobalSearchStrategy;
import choco.kernel.solver.search.Limit;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;

public class CpuTimeLimit
extends AbstractGlobalSearchLimit {
    private long nanostart = Long.MIN_VALUE;
    private final ThreadMXBean thd = ManagementFactory.getThreadMXBean();

    public CpuTimeLimit(AbstractGlobalSearchStrategy theStrategy, int theLimit) {
        super(theStrategy, theLimit, Limit.CPU_TIME);
    }

    @Override
    public void reset(boolean first) {
        super.reset(first);
        this.nanostart = this.thd.getCurrentThreadCpuTime();
    }

    private boolean check() {
        long c = this.thd.getCurrentThreadCpuTime();
        this.nb = (int)((double)(c - this.nanostart) / 1000000.0);
        return this.nb + this.nbTot < this.nbMax;
    }

    @Override
    public boolean endNode(AbstractGlobalSearchStrategy strategy) {
        return this.check();
    }

    @Override
    public boolean newNode(AbstractGlobalSearchStrategy strategy) {
        return this.check();
    }
}

