/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.search.integer.varselector;

import choco.cp.solver.variables.integer.IntDomainVarImpl;
import choco.kernel.solver.Solver;
import choco.kernel.solver.search.integer.AbstractIntVarSelector;
import choco.kernel.solver.search.integer.IntVarSelector;
import choco.kernel.solver.variables.integer.IntDomainVar;
import java.util.ArrayList;
import java.util.Random;

public class RandomIntVarSelector
extends AbstractIntVarSelector
implements IntVarSelector {
    protected ArrayList<IntDomainVar> list = new ArrayList();
    protected Random random;

    public RandomIntVarSelector(Solver solver) {
        this.solver = solver;
        this.random = new Random();
    }

    public RandomIntVarSelector(Solver solver, IntDomainVar[] vs, long seed) {
        this.solver = solver;
        this.vars = vs;
        this.random = new Random(seed);
    }

    public RandomIntVarSelector(Solver solver, long seed) {
        this.solver = solver;
        this.random = new Random(seed);
    }

    @Override
    public IntDomainVar selectIntVar() {
        int i;
        if (this.vars == null) {
            for (i = 0; i < this.solver.getNbIntVars(); ++i) {
                IntDomainVar v = (IntDomainVar)this.solver.getIntVar(i);
                if (v.isInstantiated()) continue;
                this.list.add(v);
            }
        } else {
            for (i = 0; i < this.vars.length; ++i) {
                IntDomainVar v = this.vars[i];
                if (v.isInstantiated()) continue;
                this.list.add(v);
            }
        }
        IntDomainVarImpl ret = null;
        if (this.list.size() > 0) {
            ret = (IntDomainVarImpl)this.list.get(this.random.nextInt(this.list.size()));
        }
        this.list.clear();
        return ret;
    }
}

