/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.search.integer.varselector;

import choco.kernel.common.util.IntIterator;
import choco.kernel.solver.ContradictionException;
import choco.kernel.solver.Solver;
import choco.kernel.solver.constraints.AbstractSConstraint;
import choco.kernel.solver.constraints.SConstraint;
import choco.kernel.solver.constraints.SConstraintType;
import choco.kernel.solver.propagation.PropagationEngineListener;
import choco.kernel.solver.search.integer.DoubleHeuristicIntVarSelector;
import choco.kernel.solver.variables.integer.IntDomainVar;
import java.util.Iterator;

public class DomOverWDeg
extends DoubleHeuristicIntVarSelector
implements PropagationEngineListener {
    private AbstractSConstraint reuseCstr;
    private static final int ABSTRACTCONTRAINT_EXTENSION = AbstractSConstraint.getAbstractSConstraintExtensionNumber("choco.cp.cpsolver.search.integer.varselector.DomOverWDeg");

    public DomOverWDeg(Solver solver) {
        super(solver);
        Iterator<SConstraint> iter = solver.getIntConstraintIterator();
        while (iter.hasNext()) {
            AbstractSConstraint c = (AbstractSConstraint)iter.next();
            c.setExtension(ABSTRACTCONTRAINT_EXTENSION, new DomOverWDegConstraintExtension());
        }
        solver.getPropagationEngine().addPropagationEngineListener(this);
    }

    public DomOverWDeg(Solver solver, IntDomainVar[] vs) {
        super(solver);
        this.vars = vs;
        Iterator<SConstraint> iter = solver.getIntConstraintIterator();
        while (iter.hasNext()) {
            AbstractSConstraint c = (AbstractSConstraint)iter.next();
            c.setExtension(ABSTRACTCONTRAINT_EXTENSION, new DomOverWDegConstraintExtension());
        }
        solver.getPropagationEngine().addPropagationEngineListener(this);
    }

    @Override
    public double getHeuristic(IntDomainVar v) {
        int dsize = v.getDomainSize();
        int weight = 0;
        IntIterator c = v.getIndexVector().getIndexIterator();
        int idx = 0;
        while (c.hasNext()) {
            idx = c.next();
            this.reuseCstr = (AbstractSConstraint)v.getConstraint(idx);
            if (!SConstraintType.INTEGER.equals((Object)this.reuseCstr.getConstraintType()) || this.reuseCstr.getNbVarNotInst() <= 1) continue;
            weight += ((DomOverWDegConstraintExtension)this.reuseCstr.getExtension(ABSTRACTCONTRAINT_EXTENSION)).nbFailure + this.reuseCstr.getFineDegree(v.getVarIndex(idx));
        }
        if (weight == 0) {
            return Double.MAX_VALUE;
        }
        return (double)dsize / (double)weight;
    }

    @Override
    public void contradictionOccured(ContradictionException e) {
        Object cause = e.getContradictionCause();
        if (cause != null && e.getContraditionType() == 2) {
            this.reuseCstr = (AbstractSConstraint)cause;
            if (SConstraintType.INTEGER.equals((Object)this.reuseCstr.getConstraintType())) {
                ((DomOverWDegConstraintExtension)this.reuseCstr.getExtension(ABSTRACTCONTRAINT_EXTENSION)).nbFailure++;
            }
        }
    }

    protected static final class DomOverWDegConstraintExtension {
        private int nbFailure = 0;

        protected DomOverWDegConstraintExtension() {
        }
    }
}

