/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.search.integer.valselector;

import choco.kernel.common.util.DisposableIntIterator;
import choco.kernel.solver.search.integer.ValSelector;
import choco.kernel.solver.variables.integer.IntDomainVar;
import java.util.Random;

public class RandomIntValSelector
implements ValSelector {
    protected Random random;

    public RandomIntValSelector() {
        this.random = new Random();
    }

    public RandomIntValSelector(long seed) {
        this.random = new Random(seed);
    }

    @Override
    public int getBestVal(IntDomainVar x) {
        if (x.hasEnumeratedDomain()) {
            if (x.isInstantiated()) {
                return x.getVal();
            }
            int val = this.random.nextInt(x.getDomainSize());
            DisposableIntIterator iterator = x.getDomain().getIterator();
            for (int i = 0; i < val; ++i) {
                iterator.next();
            }
            int res = iterator.next();
            iterator.dispose();
            return res;
        }
        int val = this.random.nextInt(2);
        if (val == 0) {
            return x.getInf();
        }
        return x.getSup();
    }
}

