/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.search.integer.branching;

import choco.cp.solver.CPSolver;
import choco.cp.solver.variables.integer.IntDomainVarImpl;
import choco.kernel.common.util.DisposableIntIterator;
import choco.kernel.solver.ContradictionException;
import choco.kernel.solver.Solver;
import choco.kernel.solver.branch.AbstractLargeIntBranching;
import choco.kernel.solver.variables.AbstractVar;
import choco.kernel.solver.variables.integer.IntDomainVar;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.Random;

public class ImpactBasedBranching
extends AbstractLargeIntBranching {
    Solver _solver;
    IntDomainVar[] _vars;
    AbstractImpactStrategy _ibs;
    protected Random randValueChoice;
    protected Random randomBreakTies;
    private static final int ABSTRACTVAR_EXTENSION = AbstractVar.getAbstractVarExtensionNumber("choco.cp.cpsolver.search.integer.ImpactBasedBranching");

    static IntDomainVar[] varsFromSolver(Solver s) {
        IntDomainVar[] vars = new IntDomainVar[s.getNbIntVars()];
        for (int i = 0; i < vars.length; ++i) {
            vars[i] = (IntDomainVar)s.getIntVar(i);
        }
        return vars;
    }

    public ImpactBasedBranching(Solver solver, IntDomainVar[] vars, AbstractImpactStrategy ibs) {
        this._solver = solver;
        for (IntDomainVar var : this._vars = vars) {
            ((AbstractVar)((Object)var)).setExtension(ABSTRACTVAR_EXTENSION, new ImpactBasedBranchingVarExtension());
        }
        this._ibs = ibs;
    }

    public ImpactBasedBranching(Solver solver, IntDomainVar[] vars) {
        this(solver, vars, null);
        this._ibs = new ImpactRef(this, this._vars);
    }

    public ImpactBasedBranching(Solver solver) {
        this(solver, ImpactBasedBranching.varsFromSolver(solver));
    }

    public AbstractImpactStrategy getImpactStrategy() {
        return this._ibs;
    }

    public void setRandomVarTies(int seed) {
        this.randomBreakTies = new Random(seed);
    }

    @Override
    public Object selectBranchingObject() throws ContradictionException {
        double min = Double.MAX_VALUE;
        IntDomainVar minVar = null;
        if (this.randomBreakTies == null) {
            for (IntDomainVar var : this._vars) {
                double note;
                if (var.isInstantiated() || !((note = var.hasEnumeratedDomain() ? this._ibs.getEnumImpactVar(var) : this._ibs.getBoundImpactVar(var)) < min)) continue;
                min = note;
                minVar = var;
            }
            return minVar;
        }
        LinkedList<IntDomainVar> lvs = new LinkedList<IntDomainVar>();
        for (IntDomainVar var : this._vars) {
            if (var.isInstantiated()) continue;
            double note = var.hasEnumeratedDomain() ? this._ibs.getEnumImpactVar(var) : this._ibs.getBoundImpactVar(var);
            if (note < min) {
                lvs.clear();
                min = note;
                lvs.add(var);
                continue;
            }
            if (note != min) continue;
            lvs.add(var);
        }
        if (lvs.size() == 0) {
            return null;
        }
        return lvs.get(this.randomBreakTies.nextInt(lvs.size()));
    }

    @Override
    public int getFirstBranch(Object x) {
        return this.getBestVal(x);
    }

    @Override
    public int getNextBranch(Object x, int i) {
        return this.getBestVal(x);
    }

    public void setRandomValueChoice(long seed) {
        this.randValueChoice = new Random(seed);
    }

    public int getBestVal(Object x) {
        IntDomainVar var = (IntDomainVar)x;
        if (this.randValueChoice == null) {
            if (var.hasEnumeratedDomain()) {
                DisposableIntIterator iter = var.getDomain().getIterator();
                double min = Double.MAX_VALUE;
                int minVal = Integer.MAX_VALUE;
                while (iter.hasNext()) {
                    int val = iter.next();
                    double note = this._ibs.getImpactVal(var, val);
                    if (!(note < min)) continue;
                    min = note;
                    minVal = val;
                }
                iter.dispose();
                return minVal;
            }
            return var.getInf();
        }
        if (var.hasEnumeratedDomain()) {
            if (var.isInstantiated()) {
                return var.getVal();
            }
            int val = this.randValueChoice.nextInt(var.getDomainSize());
            DisposableIntIterator iterator = var.getDomain().getIterator();
            for (int i = 0; i < val; ++i) {
                iterator.next();
            }
            int res = iterator.next();
            iterator.dispose();
            return res;
        }
        int val = this.randValueChoice.nextInt(2);
        if (val == 0) {
            return var.getInf();
        }
        return var.getSup();
    }

    @Override
    public boolean finishedBranching(Object x, int i) {
        return ((IntDomainVar)x).getDomainSize() == 0;
    }

    @Override
    public void goDownBranch(Object x, int i) throws ContradictionException {
        this.logDownBranch(x, i);
        IntDomainVar y = (IntDomainVar)x;
        this._ibs.doBeforePropagDownBranch(x, i);
        try {
            y.setVal(i);
            this._solver.propagate();
        }
        catch (ContradictionException e) {
            this._ibs.doAfterFail(x, i);
            throw e;
        }
        this._ibs.doAfterPropagDownBranch(x, i);
    }

    @Override
    public void goUpBranch(Object x, int i) throws ContradictionException {
        super.goUpBranch(x, i);
        IntDomainVarImpl y = (IntDomainVarImpl)x;
        y.remVal(i);
    }

    @Override
    public String getDecisionLogMsg(int branchIndex) {
        return "==";
    }

    private final class ImpactRef
    extends AbstractImpactStrategy {
        protected double[] impact;
        protected int[] nbDecOnVarVal;
        protected ImpactBasedBranching _branching;
        protected int[] domBefore;
        protected int[] domAfter;
        protected boolean flag;

        public ImpactRef(ImpactBasedBranching branching, IntDomainVar[] subset) {
            this(branching, new ArrayList<IntDomainVar>(Arrays.asList(subset)));
        }

        public ImpactRef(ImpactBasedBranching branching, ArrayList vars) {
            super(branching, vars);
            this.flag = false;
            this._branching = branching;
            int totalSize = 0;
            if (vars.size() != 0) {
                totalSize = this.dataS.blocks[vars.size() - 1] + this.dataS.sizes[vars.size() - 1];
            }
            this.impact = new double[totalSize];
            this.nbDecOnVarVal = new int[totalSize];
            this.domBefore = new int[vars.size()];
            this.domAfter = new int[vars.size()];
        }

        public void addImpact(IntDomainVar v, int val, double value) {
            if (v.hasEnumeratedDomain()) {
                int n = this.dataS.getChoiceAddress(v, val);
                this.impact[n] = this.impact[n] + value;
            } else {
                int n = this.dataS.getChoiceAddress(v, 0);
                this.impact[n] = this.impact[n] + value;
            }
        }

        public void updateSearchState(IntDomainVar var, int val) {
            if (var.hasEnumeratedDomain()) {
                int n = this.dataS.getChoiceAddress(var, val);
                this.nbDecOnVarVal[n] = this.nbDecOnVarVal[n] + 1;
            } else {
                int n = this.dataS.getChoiceAddress(var, 0);
                this.nbDecOnVarVal[n] = this.nbDecOnVarVal[n] + 1;
            }
        }

        @Override
        public double getImpactVal(IntDomainVar var, int val) {
            int idx = this.dataS.getChoiceAddress(var, val);
            if (this.nbDecOnVarVal[idx] > 0) {
                return this.impact[idx] / (double)this.nbDecOnVarVal[idx];
            }
            return 0.0;
        }

        public double getImpactVal(int idx) {
            if (this.nbDecOnVarVal[idx] > 0) {
                return this.impact[idx] / (double)this.nbDecOnVarVal[idx];
            }
            return 0.0;
        }

        @Override
        public double getEnumImpactVar(IntDomainVar var) {
            int idx = ((ImpactBasedBranchingVarExtension)((AbstractVar)((Object)var)).getExtension(ABSTRACTVAR_EXTENSION)).index;
            if (idx != -1) {
                double imp = 0.0;
                DisposableIntIterator it = var.getDomain().getIterator();
                int blockadress = this.dataS.blocks[idx] - this.dataS.offsets[idx];
                while (it.hasNext()) {
                    int val = it.next();
                    imp += 1.0 - this.getImpactVal(blockadress + val);
                }
                return imp;
            }
            return 0.0;
        }

        @Override
        public double getBoundImpactVar(IntDomainVar var) {
            int idx = ((ImpactBasedBranchingVarExtension)((AbstractVar)((Object)var)).getExtension(ABSTRACTVAR_EXTENSION)).index;
            if (idx != -1) {
                return 1.0 - this.getImpactVal(var, 0);
            }
            return 0.0;
        }

        public void computeSearchReduction(IntDomainVar x, int val, int[] pAfter, int[] pBefore) {
            double reduc = 1.0;
            for (int i = 0; i < pAfter.length; ++i) {
                reduc *= (double)pAfter[i] / (double)pBefore[i];
            }
            reduc = 1.0 - reduc;
            this.addImpact(x, val, reduc);
        }

        public void computeCurrentDomSize(int[] domSizes) {
            for (int i = 0; i < domSizes.length; ++i) {
                domSizes[i] = ((IntDomainVar)this.svars.get(i)).getDomainSize();
            }
        }

        @Override
        public void doBeforePropagDownBranch(Object o, int i) {
            boolean bl = this.flag = ((IntDomainVar)o).getDomainSize() > 1;
            if (this.flag) {
                this.computeCurrentDomSize(this.domBefore);
                this.updateSearchState((IntDomainVar)o, i);
            }
        }

        @Override
        public void doAfterPropagDownBranch(Object o, int i) {
            if (this.flag) {
                this.computeCurrentDomSize(this.domAfter);
                this.computeSearchReduction((IntDomainVar)o, i, this.domAfter, this.domBefore);
            }
        }

        @Override
        public void doAfterFail(Object o, int i) {
            this.addImpact((IntDomainVar)o, i, 1.0);
        }
    }

    public static abstract class AbstractImpactStrategy
    implements ImpactStrategy {
        ImpactBasedBranching _branching;
        ArrayList svars;
        int nbVar;
        int sumDom = 0;
        ImpactStorage dataS;

        public AbstractImpactStrategy(ImpactBasedBranching branching, ArrayList subset) {
            this.svars = subset;
            this._branching = branching;
            this.dataS = new ImpactStorage(this._branching._solver, subset);
            this.nbVar = subset.size();
            for (Object svar : this.svars) {
                this.sumDom += ((IntDomainVar)svar).getDomainSize();
            }
        }

        public void setDataS(ImpactStorage dataS) {
            this.dataS = dataS;
        }

        public boolean initImpacts(int timelimit) {
            if (timelimit != 0) {
                long tps = System.currentTimeMillis();
                this._branching._solver.generateSearchStrategy();
                try {
                    this._branching._solver.propagate();
                    this._branching._solver.worldPush();
                    block7: for (int i = 0; i < this.svars.size(); ++i) {
                        IntDomainVar v = (IntDomainVar)this.svars.get(i);
                        if (v.isInstantiated() || !v.hasEnumeratedDomain()) continue;
                        DisposableIntIterator it = v.getDomain().getIterator();
                        while (it != null && it.hasNext()) {
                            int val = it.next();
                            boolean cont = false;
                            if (v.hasBooleanDomain() && val > v.getInf() && val < v.getSup()) continue block7;
                            this._branching._solver.worldPush();
                            try {
                                this.goDownBranch(v, val);
                            }
                            catch (ContradictionException e) {
                                cont = true;
                            }
                            this._branching._solver.worldPop();
                            if (cont) {
                                this._branching._solver.worldPop();
                                try {
                                    v.remVal(val);
                                    this._branching._solver.propagate();
                                }
                                catch (ContradictionException e) {
                                    return false;
                                }
                                this._branching._solver.worldPush();
                            }
                            if (System.currentTimeMillis() - tps <= (long)timelimit) continue;
                            this._branching._solver.worldPop();
                            this._branching._solver.getSearchStrategy().traceStack = new ArrayList();
                            ((CPSolver)this._branching._solver).resetSearchStrategy();
                            return true;
                        }
                    }
                    this._branching._solver.worldPop();
                }
                catch (ContradictionException e) {
                    return false;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                this._branching._solver.getSearchStrategy().traceStack = new ArrayList();
                ((CPSolver)this._branching._solver).resetSearchStrategy();
            }
            return true;
        }

        public void goDownBranch(Object x, int i) throws ContradictionException {
            this._branching.goDownBranch(x, i);
        }

        protected static class ImpactStorage {
            public int[] offsets;
            public int[] sizes;
            public int[] blocks;
            public Solver pb;

            public ImpactStorage(ImpactStorage impst) {
                this.offsets = impst.offsets;
                this.sizes = impst.sizes;
                this.blocks = impst.blocks;
            }

            public ImpactStorage(Solver pb, ArrayList subset) {
                this.pb = pb;
                this.offsets = new int[subset.size()];
                this.sizes = new int[subset.size()];
                this.blocks = new int[subset.size()];
                if (subset.size() > 0) {
                    this.blocks[0] = 0;
                }
                for (int i = 0; i < subset.size(); ++i) {
                    IntDomainVar tv = (IntDomainVar)subset.get(i);
                    ((ImpactBasedBranchingVarExtension)((AbstractVar)((Object)tv)).getExtension(ABSTRACTVAR_EXTENSION)).index = i;
                    if (tv.hasEnumeratedDomain()) {
                        this.offsets[i] = tv.getInf();
                        this.sizes[i] = tv.getSup() - tv.getInf() + 1;
                    } else {
                        this.offsets[i] = 0;
                        this.sizes[i] = 1;
                    }
                    if (i <= 0) continue;
                    this.blocks[i] = this.blocks[i - 1] + this.sizes[i - 1];
                }
            }

            public double computeCurrentTreeSize() {
                double prod = 1.0;
                for (int i = 0; i < this.pb.getNbIntVars(); ++i) {
                    prod *= (double)((IntDomainVar)this.pb.getIntVar(i)).getDomainSize();
                }
                return prod;
            }

            public int getChoiceAddress(IntDomainVar var, int val) {
                int idx = ((ImpactBasedBranchingVarExtension)((AbstractVar)((Object)var)).getExtension(ABSTRACTVAR_EXTENSION)).index;
                return this.blocks[idx] + val - this.offsets[idx];
            }
        }
    }

    public static interface ImpactStrategy {
        public double getEnumImpactVar(IntDomainVar var1);

        public double getBoundImpactVar(IntDomainVar var1);

        public double getImpactVal(IntDomainVar var1, int var2);

        public void doBeforePropagDownBranch(Object var1, int var2);

        public void doAfterPropagDownBranch(Object var1, int var2);

        public void doAfterFail(Object var1, int var2);
    }

    protected static final class ImpactBasedBranchingVarExtension {
        private int index = 0;

        protected ImpactBasedBranchingVarExtension() {
        }
    }
}

