/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.search.integer.branching;

import choco.kernel.common.util.IntIterator;
import choco.kernel.solver.ContradictionException;
import choco.kernel.solver.Solver;
import choco.kernel.solver.branch.AbstractLargeIntBranching;
import choco.kernel.solver.constraints.AbstractSConstraint;
import choco.kernel.solver.constraints.SConstraint;
import choco.kernel.solver.constraints.SConstraintType;
import choco.kernel.solver.constraints.integer.AbstractIntSConstraint;
import choco.kernel.solver.propagation.PropagationEngineListener;
import choco.kernel.solver.search.integer.ValIterator;
import choco.kernel.solver.search.integer.ValSelector;
import choco.kernel.solver.variables.AbstractVar;
import choco.kernel.solver.variables.Var;
import choco.kernel.solver.variables.integer.IntDomainVar;
import choco.kernel.solver.variables.integer.IntVar;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Random;

public class DomOverWDegBranching
extends AbstractLargeIntBranching
implements PropagationEngineListener {
    protected static final int ABSTRACTCONTRAINT_EXTENSION = AbstractSConstraint.getAbstractSConstraintExtensionNumber("choco.cp.cpsolver.search.integer.varselector.DomOverWDeg");
    protected static final int ABSTRACTVAR_EXTENSION = AbstractVar.getAbstractVarExtensionNumber("choco.cp.cpsolver.search.integer.varselector.DomOverWDeg");
    private IntVar[] _vars;
    private ValIterator _valIterator;
    private ValSelector _valSelector;
    private Solver _solver;
    protected Random randomBreakTies;
    private AbstractSConstraint reuseCstr;

    public DomOverWDegBranching(Solver s, ValIterator valHeuri, IntVar[] vars) {
        this._solver = s;
        Iterator<SConstraint> iter = s.getIntConstraintIterator();
        while (iter.hasNext()) {
            AbstractSConstraint c = (AbstractSConstraint)iter.next();
            c.setExtension(ABSTRACTCONTRAINT_EXTENSION, new DomOverWDegBranchingConstraintExtension());
        }
        for (int i = 0; i < s.getNbIntVars(); ++i) {
            IntVar v = s.getIntVar(i);
            ((AbstractVar)((Object)v)).setExtension(ABSTRACTVAR_EXTENSION, new DomOverWDegBranchingVarExtension());
        }
        for (int val : s.getIntConstantSet()) {
            Var v = s.getIntConstant(val);
            ((AbstractVar)v).setExtension(ABSTRACTVAR_EXTENSION, new DomOverWDegBranchingVarExtension());
        }
        s.getPropagationEngine().addPropagationEngineListener(this);
        this._valIterator = valHeuri;
        this._vars = vars;
    }

    public DomOverWDegBranching(Solver s, ValIterator valHeuri) {
        this(s, valHeuri, DomOverWDegBranching.buildVars(s));
    }

    public DomOverWDegBranching(Solver s, ValSelector valHeuri, IntVar[] vars) {
        this._solver = s;
        Iterator<SConstraint> iter = s.getIntConstraintIterator();
        while (iter.hasNext()) {
            AbstractSConstraint c = (AbstractSConstraint)iter.next();
            c.setExtension(ABSTRACTCONTRAINT_EXTENSION, new DomOverWDegBranchingConstraintExtension());
        }
        for (int i = 0; i < s.getNbIntVars(); ++i) {
            IntVar v = s.getIntVar(i);
            ((AbstractVar)((Object)v)).setExtension(ABSTRACTVAR_EXTENSION, new DomOverWDegBranchingVarExtension());
        }
        for (int val : s.getIntConstantSet()) {
            Var v = s.getIntConstant(val);
            ((AbstractVar)v).setExtension(ABSTRACTVAR_EXTENSION, new DomOverWDegBranchingVarExtension());
        }
        s.getPropagationEngine().addPropagationEngineListener(this);
        this._valSelector = valHeuri;
        this._vars = vars;
    }

    public DomOverWDegBranching(Solver s, ValSelector valHeuri) {
        this(s, valHeuri, DomOverWDegBranching.buildVars(s));
    }

    private static IntVar[] buildVars(Solver s) {
        IntVar[] vars = new IntVar[s.getNbIntVars()];
        for (int i = 0; i < vars.length; ++i) {
            vars[i] = s.getIntVar(i);
        }
        return vars;
    }

    @Override
    public void initBranching() {
        for (IntVar v : this._vars) {
            int weight = 0;
            IntIterator c = v.getIndexVector().getIndexIterator();
            int idx = 0;
            while (c.hasNext()) {
                idx = c.next();
                AbstractSConstraint cstr = (AbstractSConstraint)v.getConstraint(idx);
                if (cstr.getNbVarNotInst() <= 1) continue;
                weight += ((DomOverWDegBranchingConstraintExtension)cstr.getExtension((int)DomOverWDegBranching.ABSTRACTCONTRAINT_EXTENSION)).nbFailure + cstr.getFineDegree(v.getVarIndex(idx));
            }
            ((DomOverWDegBranchingVarExtension)((AbstractVar)((Object)v)).getExtension((int)DomOverWDegBranching.ABSTRACTVAR_EXTENSION)).sum_weighted = weight;
        }
    }

    @Override
    public void initConstraintForBranching(SConstraint c) {
        ((AbstractSConstraint)c).setExtension(ABSTRACTCONTRAINT_EXTENSION, new DomOverWDegBranchingConstraintExtension());
    }

    public void setBranchingVars(IntVar[] vs) {
        this._vars = vs;
    }

    public void setRandomVarTies(int seed) {
        this.randomBreakTies = new Random(seed);
    }

    @Override
    public Object selectBranchingObject() throws ContradictionException {
        int previous_Size = -1;
        int previous_Weight = -1;
        IntDomainVar previous_Variable = null;
        if (this.randomBreakTies == null) {
            for (int i = 0; i < this._vars.length; ++i) {
                IntDomainVar var = (IntDomainVar)this._vars[i];
                if (var.isInstantiated() || var.isInstantiated()) continue;
                if (previous_Variable == null) {
                    previous_Variable = var;
                    previous_Size = var.getDomainSize();
                    previous_Weight = ((DomOverWDegBranchingVarExtension)((AbstractVar)((Object)var)).getExtension((int)DomOverWDegBranching.ABSTRACTVAR_EXTENSION)).sum_weighted;
                    continue;
                }
                if (((DomOverWDegBranchingVarExtension)((AbstractVar)((Object)var)).getExtension((int)DomOverWDegBranching.ABSTRACTVAR_EXTENSION)).sum_weighted * previous_Size - previous_Weight * var.getDomainSize() <= 0) continue;
                previous_Variable = var;
                previous_Size = var.getDomainSize();
                previous_Weight = ((DomOverWDegBranchingVarExtension)((AbstractVar)((Object)var)).getExtension((int)DomOverWDegBranching.ABSTRACTVAR_EXTENSION)).sum_weighted;
            }
            return previous_Variable;
        }
        LinkedList<IntDomainVar> lvs = new LinkedList<IntDomainVar>();
        for (int i = 0; i < this._vars.length; ++i) {
            IntDomainVar var = (IntDomainVar)this._vars[i];
            if (var.isInstantiated() || var.isInstantiated()) continue;
            if (previous_Variable == null) {
                previous_Variable = var;
                previous_Size = var.getDomainSize();
                previous_Weight = ((DomOverWDegBranchingVarExtension)((AbstractVar)((Object)var)).getExtension((int)DomOverWDegBranching.ABSTRACTVAR_EXTENSION)).sum_weighted;
                lvs.add(var);
                continue;
            }
            int note = ((DomOverWDegBranchingVarExtension)((AbstractVar)((Object)var)).getExtension((int)DomOverWDegBranching.ABSTRACTVAR_EXTENSION)).sum_weighted * previous_Size - previous_Weight * var.getDomainSize();
            if (note > 0) {
                lvs.clear();
                lvs.add(var);
                previous_Size = var.getDomainSize();
                previous_Weight = ((DomOverWDegBranchingVarExtension)((AbstractVar)((Object)var)).getExtension((int)DomOverWDegBranching.ABSTRACTVAR_EXTENSION)).sum_weighted;
                continue;
            }
            if (note < 0) continue;
            lvs.add(var);
        }
        if (lvs.size() == 0) {
            return null;
        }
        return lvs.get(this.randomBreakTies.nextInt(lvs.size()));
    }

    @Override
    public int getFirstBranch(Object x) {
        IntDomainVar v = (IntDomainVar)x;
        Iterator<SConstraint> iter = v.getConstraintsIterator();
        while (iter.hasNext()) {
            this.reuseCstr = (AbstractSConstraint)iter.next();
            if (!SConstraintType.INTEGER.equals((Object)this.reuseCstr.getConstraintType()) || this.reuseCstr.getNbVarNotInst() != 2) continue;
            for (int k = 0; k < this.reuseCstr.getNbVars(); ++k) {
                AbstractVar var = (AbstractVar)((Object)((AbstractIntSConstraint)this.reuseCstr).getIntVar(k));
                if (var == v || var.isInstantiated()) continue;
                ((DomOverWDegBranchingVarExtension)var.getExtension((int)DomOverWDegBranching.ABSTRACTVAR_EXTENSION)).sum_weighted -= ((DomOverWDegBranchingConstraintExtension)this.reuseCstr.getExtension((int)DomOverWDegBranching.ABSTRACTCONTRAINT_EXTENSION)).nbFailure;
            }
        }
        if (this._valIterator != null) {
            return this._valIterator.getFirstVal((IntDomainVar)x);
        }
        return this._valSelector.getBestVal((IntDomainVar)x);
    }

    @Override
    public int getNextBranch(Object x, int i) {
        if (this._valIterator != null) {
            return this._valIterator.getNextVal((IntDomainVar)x, i);
        }
        return this._valSelector.getBestVal((IntDomainVar)x);
    }

    @Override
    public boolean finishedBranching(Object x, int i) {
        if (this._valIterator != null) {
            boolean finished;
            boolean bl = finished = !this._valIterator.hasNextVal((IntDomainVar)x, i);
            if (finished) {
                IntDomainVar v = (IntDomainVar)x;
                Iterator<SConstraint> iter = v.getConstraintsIterator();
                while (iter.hasNext()) {
                    this.reuseCstr = (AbstractSConstraint)iter.next();
                    if (!SConstraintType.INTEGER.equals((Object)this.reuseCstr.getConstraintType()) || this.reuseCstr.getNbVarNotInst() != 2) continue;
                    for (int k = 0; k < this.reuseCstr.getNbVars(); ++k) {
                        AbstractVar var = (AbstractVar)((Object)((AbstractIntSConstraint)this.reuseCstr).getIntVar(k));
                        if (var == v || var.isInstantiated()) continue;
                        ((DomOverWDegBranchingVarExtension)var.getExtension((int)DomOverWDegBranching.ABSTRACTVAR_EXTENSION)).sum_weighted += ((DomOverWDegBranchingConstraintExtension)this.reuseCstr.getExtension((int)DomOverWDegBranching.ABSTRACTCONTRAINT_EXTENSION)).nbFailure;
                    }
                }
            }
            return finished;
        }
        return false;
    }

    @Override
    public void goDownBranch(Object x, int i) throws ContradictionException {
        super.goDownBranch(x, i);
        IntDomainVar v = (IntDomainVar)x;
        v.setVal(i);
    }

    @Override
    public void goUpBranch(Object x, int i) throws ContradictionException {
        super.goUpBranch(x, i);
    }

    @Override
    public void contradictionOccured(ContradictionException e) {
        Object cause = e.getContradictionCause();
        if (cause != null && e.getContraditionType() == 2) {
            this.reuseCstr = (AbstractSConstraint)cause;
            if (SConstraintType.INTEGER.equals((Object)this.reuseCstr.getConstraintType())) {
                try {
                    ++((DomOverWDegBranchingConstraintExtension)this.reuseCstr.getExtension((int)DomOverWDegBranching.ABSTRACTCONTRAINT_EXTENSION)).nbFailure;
                }
                catch (NullPointerException npe) {
                    this.reuseCstr.setExtension(ABSTRACTCONTRAINT_EXTENSION, new DomOverWDegBranchingConstraintExtension());
                    ++((DomOverWDegBranchingConstraintExtension)this.reuseCstr.getExtension((int)DomOverWDegBranching.ABSTRACTCONTRAINT_EXTENSION)).nbFailure;
                }
                for (int k = 0; k < this.reuseCstr.getNbVars(); ++k) {
                    AbstractVar var = (AbstractVar)((Object)((AbstractIntSConstraint)this.reuseCstr).getIntVar(k));
                    DomOverWDegBranchingVarExtension extens = (DomOverWDegBranchingVarExtension)var.getExtension(ABSTRACTVAR_EXTENSION);
                    ++extens.sum_weighted;
                }
            }
        }
    }

    @Override
    public String getDecisionLogMsg(int branchIndex) {
        return "==";
    }

    protected static final class DomOverWDegBranchingVarExtension {
        protected int sum_weighted = 0;

        protected DomOverWDegBranchingVarExtension() {
        }

        public int getSumWeights() {
            return this.sum_weighted;
        }

        public void addWeight(int w) {
            this.sum_weighted += w;
        }
    }

    protected static final class DomOverWDegBranchingConstraintExtension {
        protected int nbFailure = 0;

        protected DomOverWDegBranchingConstraintExtension() {
        }

        public int getSumWeights() {
            return this.nbFailure;
        }

        public void addFailure() {
            ++this.nbFailure;
        }
    }
}

