/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.search.integer.branching;

import choco.cp.solver.variables.integer.IntDomainVarImpl;
import choco.kernel.solver.ContradictionException;
import choco.kernel.solver.branch.AbstractLargeIntBranching;
import choco.kernel.solver.branch.VarSelector;
import choco.kernel.solver.search.integer.ValIterator;
import choco.kernel.solver.search.integer.ValSelector;
import choco.kernel.solver.variables.integer.IntDomainVar;

public class AssignVar
extends AbstractLargeIntBranching {
    private VarSelector varHeuristic;
    private ValIterator valHeuristic;
    private ValSelector valSHeuristic;
    protected ValueChooserWrapper wrapper;
    String[] LOG_DECISION_MSG = new String[]{"=="};

    public AssignVar(VarSelector varSel, ValIterator valHeuri) {
        this.varHeuristic = varSel;
        this.valHeuristic = valHeuri;
        this.wrapper = new ValIteratorWrapper();
    }

    public AssignVar(VarSelector varSel, ValSelector valHeuri) {
        this.varHeuristic = varSel;
        this.valSHeuristic = valHeuri;
        this.wrapper = new ValSelectorWrapper();
    }

    @Override
    public Object selectBranchingObject() throws ContradictionException {
        return this.varHeuristic.selectVar();
    }

    @Override
    public boolean finishedBranching(Object x, int i) {
        return this.wrapper.finishedBranching(x, i);
    }

    @Override
    public int getFirstBranch(Object x) {
        return this.wrapper.getFirstBranch(x);
    }

    @Override
    public int getNextBranch(Object x, int i) {
        return this.wrapper.getNextBranch(x, i);
    }

    @Override
    public void goDownBranch(Object x, int i) throws ContradictionException {
        super.goDownBranch(x, i);
        IntDomainVarImpl y = (IntDomainVarImpl)x;
        y.setVal(i);
    }

    @Override
    public void goUpBranch(Object x, int i) throws ContradictionException {
        super.goUpBranch(x, i);
        IntDomainVarImpl y = (IntDomainVarImpl)x;
        y.remVal(i);
    }

    @Override
    public String getDecisionLogMsg(int branchIndex) {
        return this.LOG_DECISION_MSG[0];
    }

    protected class ValSelectorWrapper
    implements ValueChooserWrapper {
        protected ValSelectorWrapper() {
        }

        @Override
        public boolean finishedBranching(Object x, int i) {
            return ((IntDomainVar)x).getDomainSize() == 0;
        }

        @Override
        public int getFirstBranch(Object x) {
            return AssignVar.this.valSHeuristic.getBestVal((IntDomainVar)x);
        }

        @Override
        public int getNextBranch(Object x, int i) {
            return AssignVar.this.valSHeuristic.getBestVal((IntDomainVar)x);
        }
    }

    protected class ValIteratorWrapper
    implements ValueChooserWrapper {
        protected ValIteratorWrapper() {
        }

        @Override
        public boolean finishedBranching(Object x, int i) {
            return !AssignVar.this.valHeuristic.hasNextVal((IntDomainVar)x, i);
        }

        @Override
        public int getFirstBranch(Object x) {
            return AssignVar.this.valHeuristic.getFirstVal((IntDomainVar)x);
        }

        @Override
        public int getNextBranch(Object x, int i) {
            return AssignVar.this.valHeuristic.getNextVal((IntDomainVar)x, i);
        }
    }

    protected static interface ValueChooserWrapper {
        public boolean finishedBranching(Object var1, int var2);

        public int getFirstBranch(Object var1);

        public int getNextBranch(Object var1, int var2);
    }
}

