/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.search.integer.branching;

import choco.kernel.solver.ContradictionException;
import choco.kernel.solver.branch.AbstractBinIntBranching;
import choco.kernel.solver.branch.VarSelector;
import choco.kernel.solver.search.integer.IntVarValPair;
import choco.kernel.solver.search.integer.ValSelector;
import choco.kernel.solver.search.integer.VarValPairSelector;
import choco.kernel.solver.variables.integer.IntDomainVar;
import java.util.logging.Level;

public class AssignOrForbidIntVarVal
extends AbstractBinIntBranching {
    private VarSelector varHeuristic;
    private ValSelector valSHeuristic;
    private VarValPairSelector pairHeuristic;

    public AssignOrForbidIntVarVal(VarSelector varHeuristic, ValSelector valSHeuristic) {
        this.varHeuristic = varHeuristic;
        this.valSHeuristic = valSHeuristic;
    }

    public AssignOrForbidIntVarVal(VarValPairSelector pairh) {
        this.pairHeuristic = pairh;
    }

    @Override
    public String getDecisionLogMsg(int branchIndex) {
        if (branchIndex == 0) {
            return "==";
        }
        return "!=";
    }

    @Override
    public void goDownBranch(Object x, int i) throws ContradictionException {
        super.goDownBranch(x, i);
        IntVarValPair p = (IntVarValPair)x;
        if (i == 0) {
            p.var.setVal(p.val);
        } else {
            p.var.remVal(p.val);
        }
    }

    @Override
    protected void logDownBranch(Object x, int i) {
        int n;
        if (logger.isLoggable(Level.FINE) && (n = this.manager.solver.getEnvironment().getWorldIndex()) <= this.manager.getLoggingMaxDepth()) {
            IntVarValPair p = (IntVarValPair)x;
            logger.log(Level.FINE, LOG_DOWN_MSG, new Object[]{n, p.var, this.getDecisionLogMsg(i), p.val});
        }
    }

    @Override
    protected void logUpBranch(Object x, int i) {
        int n;
        if (logger.isLoggable(Level.FINE) && (n = this.manager.solver.getEnvironment().getWorldIndex()) <= this.manager.getLoggingMaxDepth()) {
            IntVarValPair p = (IntVarValPair)x;
            logger.log(Level.FINE, LOG_UP_MSG, new Object[]{n + 1, p.var, this.getDecisionLogMsg(i), p.val});
        }
    }

    @Override
    public Object selectBranchingObject() throws ContradictionException {
        if (this.pairHeuristic != null) {
            return this.pairHeuristic.selectVarValPair();
        }
        IntDomainVar v = (IntDomainVar)((Object)this.varHeuristic.selectVar());
        if (v == null) {
            return null;
        }
        return new IntVarValPair(v, this.valSHeuristic.getBestVal(v));
    }
}

