/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.search;

import choco.cp.solver.CPSolver;
import choco.cp.solver.search.SearchLoop;
import choco.cp.solver.search.restart.RestartStrategy;
import choco.kernel.solver.ContradictionException;
import choco.kernel.solver.SolverException;
import choco.kernel.solver.search.AbstractGlobalSearchLimit;
import choco.kernel.solver.search.AbstractGlobalSearchStrategy;
import choco.kernel.solver.search.IntBranchingTrace;

public class SearchLoopWithRestart
extends SearchLoop {
    protected RestartStrategy restartStrategy;
    protected int nbRestarts = 0;
    protected int restartMoveMask = 7;

    public SearchLoopWithRestart(AbstractGlobalSearchStrategy searchStrategy, RestartStrategy restartStrategy) {
        super(searchStrategy);
        this.restartStrategy = restartStrategy;
    }

    public final RestartStrategy getRestartStrategy() {
        return this.restartStrategy;
    }

    public final int getRestartCount() {
        return this.nbRestarts;
    }

    public final int getRestartMoveMask() {
        return this.restartMoveMask;
    }

    public void setRestartMoveMask(int restartMask) {
        if (restartMask == 0) {
            throw new SolverException("empty move mask is forbidden");
        }
        this.restartMoveMask = restartMask;
    }

    protected final boolean checkRestartMoveMask(int move) {
        return (this.restartMoveMask & move) == move;
    }

    protected void restoreRootNode(IntBranchingTrace ctx) {
        this.searchStrategy.popTraceUntil(this.searchStrategy.baseWorld + 1);
        this.searchStrategy.solver.worldPopUntil(this.searchStrategy.baseWorld + 1);
    }

    protected boolean restart(IntBranchingTrace ctx) {
        if (this.searchStrategy.nextMove == 2 && this.searchStrategy.currentTraceIndex < 0) {
            return true;
        }
        this.restoreRootNode(ctx);
        this.searchStrategy.nextMove = 1;
        ctx.setBranching(this.searchStrategy.mainGoal);
        this.searchStrategy.currentTraceIndex = -1;
        try {
            this.searchStrategy.postDynamicCut();
            this.searchStrategy.solver.propagate();
        }
        catch (ContradictionException e) {
            return true;
        }
        ++this.nbRestarts;
        return false;
    }

    @Override
    public Boolean run() {
        boolean restartLimit;
        int previousNbSolutions = this.searchStrategy.nbSolutions;
        this.searchStrategy.setEncounteredLimit(null);
        this.ctx = null;
        this.stop = false;
        this.init();
        do {
            restartLimit = false;
            CPSolver.flushLogs();
            while (!this.stop) {
                if (this.checkRestartMoveMask(this.searchStrategy.nextMove) && this.restartStrategy.shouldRestart(this.searchStrategy)) {
                    this.stop = this.restart(this.ctx);
                    if (this.stop) break;
                    restartLimit = true;
                    break;
                }
                switch (this.searchStrategy.nextMove) {
                    case 1: {
                        this.openNode();
                        break;
                    }
                    case 2: {
                        this.upBranch();
                        break;
                    }
                    case 4: {
                        this.downBranch();
                    }
                }
            }
            for (int i = 0; i < this.searchStrategy.limits.size(); ++i) {
                AbstractGlobalSearchLimit lim = this.searchStrategy.limits.get(i);
                lim.reset(false);
            }
        } while (restartLimit);
        if (this.searchStrategy.nbSolutions > previousNbSolutions) {
            return Boolean.TRUE;
        }
        if (this.searchStrategy.isEncounteredLimit()) {
            return null;
        }
        return Boolean.FALSE;
    }
}

