/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.search;

import choco.cp.solver.search.SearchLoop;
import choco.kernel.memory.recomputation.EnvironmentRecomputation;
import choco.kernel.solver.ContradictionException;
import choco.kernel.solver.branch.AbstractIntBranching;
import choco.kernel.solver.search.AbstractGlobalSearchStrategy;
import choco.kernel.solver.search.IntBranchingTrace;

public class SearchLoopWithRecomputation
extends SearchLoop {
    private EnvironmentRecomputation env = null;

    public SearchLoopWithRecomputation(AbstractGlobalSearchStrategy searchStrategy) {
        super(searchStrategy);
    }

    @Override
    public Boolean run() {
        this.env = (EnvironmentRecomputation)this.searchStrategy.solver.getEnvironment();
        return super.run();
    }

    @Override
    public final void init() {
        if (this.searchStrategy.nextMove == 0) {
            this.searchStrategy.nextMove = 1;
            this.ctx = new IntBranchingTrace(this.searchStrategy.mainGoal);
        } else {
            this.ctx = this.searchStrategy.topTrace();
        }
    }

    @Override
    public void openNode() {
        try {
            AbstractIntBranching currentBranching;
            this.searchStrategy.solver.propagate();
            this.searchStrategy.newTreeNode();
            Object branchingObj = null;
            AbstractIntBranching nextBranching = currentBranching = (AbstractIntBranching)this.ctx.getBranching();
            do {
                currentBranching = nextBranching;
                branchingObj = currentBranching.selectBranchingObject();
                nextBranching = (AbstractIntBranching)currentBranching.getNextBranching();
            } while (branchingObj == null && nextBranching != null);
            if (branchingObj != null) {
                this.ctx = this.searchStrategy.pushTrace();
                this.ctx.setBranching(currentBranching);
                this.ctx.setBranchingObject(branchingObj);
                this.ctx.setBranchIndex(currentBranching.getFirstBranch(this.ctx.getBranchingObject()));
                this.searchStrategy.nextMove = 4;
            } else {
                this.searchStrategy.recordSolution();
                this.searchStrategy.nextMove = 2;
                this.stop = true;
            }
        }
        catch (ContradictionException e) {
            this.searchStrategy.nextMove = 2;
            this.env.setLastFail(this.env.getWorldIndex());
        }
    }

    @Override
    public void upBranch() {
        if (this.searchStrategy.currentTraceIndex < 0) {
            this.stop = true;
        } else {
            try {
                this.env.incNbFail();
                this.searchStrategy.solver.worldPop();
                this.searchStrategy.endTreeNode();
                this.searchStrategy.postDynamicCut();
                this.ctx.getBranching().goUpBranch(this.ctx.getBranchingObject(), this.ctx.getBranchIndex());
                this.searchStrategy.solver.propagate();
                if (!this.ctx.getBranching().finishedBranching(this.ctx.getBranchingObject(), this.ctx.getBranchIndex())) {
                    this.ctx.setBranchIndex(this.ctx.getBranching().getNextBranch(this.ctx.getBranchingObject(), this.ctx.getBranchIndex()));
                    this.searchStrategy.nextMove = 4;
                } else {
                    this.ctx = this.searchStrategy.popTrace();
                    this.searchStrategy.nextMove = 2;
                }
            }
            catch (ContradictionException e) {
                this.ctx = this.searchStrategy.popTrace();
                this.searchStrategy.nextMove = 2;
                this.env.setLastFail(this.env.getWorldIndex());
            }
        }
    }

    @Override
    public void downBranch() {
        try {
            this.env.pushContext(this.ctx, true);
            this.env.worldPush();
            this.searchStrategy.solver.propagate();
            this.ctx.getBranching().goDownBranch(this.ctx.getBranchingObject(), this.ctx.getBranchIndex());
            this.searchStrategy.solver.propagate();
            this.searchStrategy.nextMove = 1;
        }
        catch (ContradictionException e) {
            this.searchStrategy.nextMove = 2;
            this.env.setLastFail(this.env.getWorldIndex());
        }
    }
}

