/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.search;

import choco.kernel.solver.ContradictionException;
import choco.kernel.solver.branch.AbstractBranching;
import choco.kernel.solver.branch.AbstractIntBranching;
import choco.kernel.solver.search.AbstractGlobalSearchLimit;
import choco.kernel.solver.search.AbstractGlobalSearchStrategy;
import choco.kernel.solver.search.ISearchLoop;
import choco.kernel.solver.search.IntBranchingTrace;

public class SearchLoop
implements ISearchLoop {
    protected AbstractGlobalSearchStrategy searchStrategy;
    protected IntBranchingTrace ctx = null;
    protected boolean stop = false;

    public SearchLoop(AbstractGlobalSearchStrategy searchStrategy) {
        this.searchStrategy = searchStrategy;
    }

    @Override
    public Boolean run() {
        int previousNbSolutions = this.searchStrategy.nbSolutions;
        this.searchStrategy.setEncounteredLimit(null);
        this.ctx = null;
        this.stop = false;
        this.init();
        while (!this.stop) {
            switch (this.searchStrategy.nextMove) {
                case 1: {
                    this.openNode();
                    break;
                }
                case 2: {
                    this.upBranch();
                    break;
                }
                case 4: {
                    this.downBranch();
                }
            }
        }
        for (int i = 0; i < this.searchStrategy.limits.size(); ++i) {
            AbstractGlobalSearchLimit lim = this.searchStrategy.limits.get(i);
            lim.reset(false);
        }
        if (this.searchStrategy.nbSolutions > previousNbSolutions) {
            return Boolean.TRUE;
        }
        if (this.searchStrategy.isEncounteredLimit()) {
            return null;
        }
        return Boolean.FALSE;
    }

    @Override
    public void init() {
        if (this.searchStrategy.nextMove == 0) {
            this.searchStrategy.nextMove = 1;
            this.ctx = new IntBranchingTrace(this.searchStrategy.mainGoal);
            for (AbstractBranching b = this.searchStrategy.mainGoal; b != null; b = b.getNextBranching()) {
                b.initBranching();
            }
        } else {
            this.ctx = this.searchStrategy.topTrace();
        }
    }

    @Override
    public void openNode() {
        try {
            AbstractIntBranching currentBranching;
            this.searchStrategy.newTreeNode();
            Object branchingObj = null;
            AbstractIntBranching nextBranching = currentBranching = (AbstractIntBranching)this.ctx.getBranching();
            while (branchingObj == null && nextBranching != null) {
                currentBranching = nextBranching;
                branchingObj = currentBranching.selectBranchingObject();
                nextBranching = (AbstractIntBranching)currentBranching.getNextBranching();
            }
            if (branchingObj != null) {
                this.ctx = this.searchStrategy.pushTrace();
                this.ctx.setBranching(currentBranching);
                this.ctx.setBranchingObject(branchingObj);
                this.ctx.setBranchIndex(currentBranching.getFirstBranch(this.ctx.getBranchingObject()));
                this.searchStrategy.nextMove = 4;
            } else {
                this.searchStrategy.recordSolution();
                this.searchStrategy.nextMove = 2;
                this.stop = true;
            }
        }
        catch (ContradictionException e) {
            this.searchStrategy.nextMove = 2;
        }
    }

    @Override
    public void upBranch() {
        if (this.searchStrategy.currentTraceIndex < 0) {
            this.stop = true;
        } else {
            try {
                this.searchStrategy.solver.worldPop();
                this.searchStrategy.endTreeNode();
                this.searchStrategy.postDynamicCut();
                this.ctx.getBranching().goUpBranch(this.ctx.getBranchingObject(), this.ctx.getBranchIndex());
                this.searchStrategy.solver.propagate();
                if (!this.ctx.getBranching().finishedBranching(this.ctx.getBranchingObject(), this.ctx.getBranchIndex())) {
                    this.ctx.setBranchIndex(this.ctx.getBranching().getNextBranch(this.ctx.getBranchingObject(), this.ctx.getBranchIndex()));
                    this.searchStrategy.nextMove = 4;
                } else {
                    this.ctx = this.searchStrategy.popTrace();
                    this.searchStrategy.nextMove = 2;
                }
            }
            catch (ContradictionException e) {
                this.ctx = this.searchStrategy.popTrace();
                this.searchStrategy.nextMove = 2;
            }
        }
    }

    @Override
    public void downBranch() {
        try {
            this.searchStrategy.solver.getEnvironment().worldPush();
            this.ctx.getBranching().goDownBranch(this.ctx.getBranchingObject(), this.ctx.getBranchIndex());
            this.searchStrategy.solver.propagate();
            this.searchStrategy.nextMove = 1;
        }
        catch (ContradictionException e) {
            this.searchStrategy.nextMove = 2;
        }
    }
}

